/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationConstants;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.UUIDGenerator;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SecurityContextToken {
    protected Element element = null;
    protected Element elementIdentifier = null;
    private WSSConfig wssConfig = WSSConfig.getNewInstance();
    private String tokenType = "http://schemas.xmlsoap.org/ws/2005/02/sc/sct";

    public SecurityContextToken(Document doc) throws ConversationException {
        this(1, doc);
    }

    public SecurityContextToken(Document doc, String uuid) throws ConversationException {
        this(1, doc, uuid);
    }

    public SecurityContextToken(int version, Document doc) throws ConversationException {
        String ns = ConversationConstants.getWSCNs(version);
        this.element = doc.createElementNS(ns, "wsc:SecurityContextToken");
        WSSecurityUtil.setNamespace(this.element, ns, "wsc");
        this.elementIdentifier = doc.createElementNS(ns, "wsc:Identifier");
        this.element.appendChild(this.elementIdentifier);
        String uuid = UUIDGenerator.getUUID();
        this.elementIdentifier.appendChild(doc.createTextNode(uuid));
        this.setID(this.wssConfig.getIdAllocator().createSecureId("sctId-", this.element));
    }

    public SecurityContextToken(int version, Document doc, String uuid) throws ConversationException {
        String ns = ConversationConstants.getWSCNs(version);
        this.element = doc.createElementNS(ns, "wsc:SecurityContextToken");
        WSSecurityUtil.setNamespace(this.element, ns, "wsc");
        this.elementIdentifier = doc.createElementNS(ns, "wsc:Identifier");
        this.element.appendChild(this.elementIdentifier);
        this.elementIdentifier.appendChild(doc.createTextNode(uuid));
        this.tokenType = version == 1 ? "http://schemas.xmlsoap.org/ws/2005/02/sc/sct" : "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct";
    }

    public SecurityContextToken(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (el.equals(ConversationConstants.SECURITY_CTX_TOKEN_QNAME_05_02)) {
            this.tokenType = "http://schemas.xmlsoap.org/ws/2005/02/sc/sct";
        } else if (el.equals(ConversationConstants.SECURITY_CTX_TOKEN_QNAME_05_12)) {
            this.tokenType = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct";
        } else {
            throw new WSSecurityException(4);
        }
        this.elementIdentifier = WSSecurityUtil.getDirectChildElement(this.element, "Identifier", el.getNamespaceURI());
    }

    public void addWSUNamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
    }

    public void setIdentifier(String uuid) {
        Text node = this.getFirstNode(this.elementIdentifier);
        node.setData(uuid);
    }

    public String getIdentifier() {
        if (this.elementIdentifier != null) {
            return this.getFirstNode(this.elementIdentifier).getData();
        }
        return null;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setElement(Element elem) {
        this.element.appendChild(elem);
    }

    private Text getFirstNode(Element e) {
        Node node = e.getFirstChild();
        return node != null && 3 == node.getNodeType() ? (Text)node : null;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public void setID(String id) {
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
    }

    public int hashCode() {
        int result = 17;
        String identifier = this.getIdentifier();
        if (identifier != null) {
            result = 31 * result + identifier.hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SecurityContextToken)) {
            return false;
        }
        SecurityContextToken securityToken = (SecurityContextToken)object;
        return this.compare(this.getIdentifier(), securityToken.getIdentifier());
    }

    private boolean compare(String item1, String item2) {
        if (item1 == null && item2 != null) {
            return false;
        }
        return item1 == null || item1.equals(item2);
    }
}

