/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.ReferenceListProcessor;
import org.apache.ws.security.processor.X509Util;
import org.apache.ws.security.str.EncryptedKeySTRParser;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.JCEMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedKeyProcessor
implements Processor {
    private static Log log = LogFactory.getLog(EncryptedKeyProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found encrypted key element");
        }
        if (data.getDecCrypto() == null) {
            throw new WSSecurityException(0, "noDecCryptoFile");
        }
        if (data.getCallbackHandler() == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        String encryptedKeyTransportMethod = X509Util.getEncAlgo(elem);
        if (encryptedKeyTransportMethod == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        if (data.getWssConfig().isWsiBSPCompliant()) {
            this.checkBSPCompliance(elem, encryptedKeyTransportMethod);
        }
        Cipher cipher = WSSecurityUtil.getCipherInstance(encryptedKeyTransportMethod);
        Element tmpE = WSSecurityUtil.getDirectChildElement(elem, "CipherData", "http://www.w3.org/2001/04/xmlenc#");
        Element xencCipherValue = null;
        if (tmpE != null) {
            xencCipherValue = WSSecurityUtil.getDirectChildElement(tmpE, "CipherValue", "http://www.w3.org/2001/04/xmlenc#");
        }
        if (xencCipherValue == null) {
            throw new WSSecurityException(3, "noCipher");
        }
        X509Certificate[] certs = this.getCertificatesFromEncryptedKey(elem, data, data.getDecCrypto(), wsDocInfo);
        try {
            PrivateKey privateKey = data.getDecCrypto().getPrivateKey(certs[0], data.getCallbackHandler());
            cipher.init(2, privateKey);
        }
        catch (Exception ex) {
            throw new WSSecurityException(6, null, null, ex);
        }
        List<String> dataRefURIs = this.getDataRefURIs(elem);
        byte[] encryptedEphemeralKey = null;
        byte[] decryptedBytes = null;
        try {
            encryptedEphemeralKey = EncryptedKeyProcessor.getDecodedBase64EncodedData(xencCipherValue);
            decryptedBytes = cipher.doFinal(encryptedEphemeralKey);
        }
        catch (IllegalStateException ex) {
            throw new WSSecurityException(6, null, null, ex);
        }
        catch (Exception ex) {
            decryptedBytes = EncryptedKeyProcessor.getRandomKey(dataRefURIs, elem.getOwnerDocument(), wsDocInfo);
        }
        List<WSDataRef> dataRefs = this.decryptDataRefs(dataRefURIs, elem.getOwnerDocument(), wsDocInfo, decryptedBytes);
        WSSecurityEngineResult result = new WSSecurityEngineResult(4, decryptedBytes, encryptedEphemeralKey, dataRefs, certs);
        result.put("encrypted-key-transport-method", encryptedKeyTransportMethod);
        result.put("id", elem.getAttribute("Id"));
        wsDocInfo.addResult(result);
        wsDocInfo.addTokenElement(elem);
        return Collections.singletonList(result);
    }

    private static byte[] getRandomKey(List<String> dataRefURIs, Document doc, WSDocInfo wsDocInfo) throws WSSecurityException {
        try {
            String alg = "AES";
            int size = 128;
            if (!dataRefURIs.isEmpty()) {
                String uri = dataRefURIs.iterator().next();
                Element ee = ReferenceListProcessor.findEncryptedDataElement(doc, wsDocInfo, uri);
                String algorithmURI = X509Util.getEncAlgo(ee);
                alg = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithmURI);
                size = JCEMapper.getKeyLengthFromURI((String)algorithmURI);
            }
            KeyGenerator kgen = KeyGenerator.getInstance(alg);
            kgen.init(size);
            SecretKey k = kgen.generateKey();
            return k.getEncoded();
        }
        catch (Exception ex) {
            throw new WSSecurityException(6, null, null, ex);
        }
    }

    private static byte[] getDecodedBase64EncodedData(Element element) throws WSSecurityException {
        StringBuilder sb = new StringBuilder();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (3 != node.getNodeType()) continue;
            sb.append(((Text)node).getData());
        }
        String encodedData = sb.toString();
        return Base64.decode(encodedData);
    }

    private X509Certificate[] getCertificatesFromEncryptedKey(Element xencEncryptedKey, RequestData data, Crypto crypto, WSDocInfo wsDocInfo) throws WSSecurityException {
        Element keyInfo = WSSecurityUtil.getDirectChildElement(xencEncryptedKey, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        if (keyInfo != null) {
            Element strElement = null;
            if (data.getWssConfig().isWsiBSPCompliant()) {
                int result = 0;
                for (Node node = keyInfo.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (1 != node.getNodeType()) continue;
                    ++result;
                    strElement = (Element)node;
                }
                if (result != 1) {
                    throw new WSSecurityException(3, "invalidDataRef");
                }
            } else {
                strElement = WSSecurityUtil.getDirectChildElement(keyInfo, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            }
            if (strElement == null) {
                throw new WSSecurityException(3, "noSecTokRef");
            }
            EncryptedKeySTRParser strParser = new EncryptedKeySTRParser();
            strParser.parseSecurityTokenReference(strElement, data, wsDocInfo, null);
            X509Certificate[] certs = strParser.getCertificates();
            if (certs == null || certs.length < 1 || certs[0] == null) {
                throw new WSSecurityException(0, "noCertsFound", new Object[]{"decryption (KeyId)"});
            }
            return certs;
        }
        if (!data.getWssConfig().isWsiBSPCompliant() && crypto.getDefaultX509Identifier() != null) {
            String alias = crypto.getDefaultX509Identifier();
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias(alias);
            X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
            if (certs == null || certs.length < 1 || certs[0] == null) {
                throw new WSSecurityException(0, "noCertsFound", new Object[]{"decryption (KeyId)"});
            }
            return certs;
        }
        throw new WSSecurityException(3, "noKeyinfo");
    }

    private List<String> getDataRefURIs(Element xencEncryptedKey) {
        Element refList = WSSecurityUtil.getDirectChildElement(xencEncryptedKey, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#");
        LinkedList<String> dataRefURIs = new LinkedList<String>();
        if (refList != null) {
            for (Node node = refList.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType() || !"http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI()) || !"DataReference".equals(node.getLocalName())) continue;
                String dataRefURI = ((Element)node).getAttribute("URI");
                if (dataRefURI.charAt(0) == '#') {
                    dataRefURI = dataRefURI.substring(1);
                }
                dataRefURIs.add(dataRefURI);
            }
        }
        return dataRefURIs;
    }

    private List<WSDataRef> decryptDataRefs(List<String> dataRefURIs, Document doc, WSDocInfo docInfo, byte[] decryptedBytes) throws WSSecurityException {
        if (dataRefURIs == null || dataRefURIs.isEmpty()) {
            return null;
        }
        ArrayList<WSDataRef> dataRefs = new ArrayList<WSDataRef>();
        for (String dataRefURI : dataRefURIs) {
            WSDataRef dataRef = this.decryptDataRef(doc, dataRefURI, docInfo, decryptedBytes);
            dataRefs.add(dataRef);
        }
        return dataRefs;
    }

    private WSDataRef decryptDataRef(Document doc, String dataRefURI, WSDocInfo docInfo, byte[] decryptedData) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("found data reference: " + dataRefURI));
        }
        Element encryptedDataElement = ReferenceListProcessor.findEncryptedDataElement(doc, docInfo, dataRefURI);
        String symEncAlgo = X509Util.getEncAlgo(encryptedDataElement);
        SecretKey symmetricKey = WSSecurityUtil.prepareSecretKey(symEncAlgo, decryptedData);
        return ReferenceListProcessor.decryptEncryptedData(doc, dataRefURI, encryptedDataElement, symmetricKey, symEncAlgo);
    }

    private void checkBSPCompliance(Element elem, String encAlgo) throws WSSecurityException {
        String attribute = elem.getAttribute("Type");
        if (attribute != null && !"".equals(attribute)) {
            throw new WSSecurityException(6, "badAttribute", new Object[]{attribute});
        }
        attribute = elem.getAttribute("MimeType");
        if (attribute != null && !"".equals(attribute)) {
            throw new WSSecurityException(6, "badAttribute", new Object[]{attribute});
        }
        attribute = elem.getAttribute("Encoding");
        if (attribute != null && !"".equals(attribute)) {
            throw new WSSecurityException(6, "badAttribute", new Object[]{attribute});
        }
        attribute = elem.getAttribute("Recipient");
        if (attribute != null && !"".equals(attribute)) {
            throw new WSSecurityException(6, "badAttribute", new Object[]{attribute});
        }
        if (!"http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(encAlgo) && !"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(encAlgo)) {
            throw new WSSecurityException(3, "badEncAlgo", new Object[]{encAlgo});
        }
    }
}

