/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.str;

import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.saml.ext.AssertionWrapper;

public final class BSPEnforcer {
    private BSPEnforcer() {
    }

    public static void checkBinarySecurityBSPCompliance(SecurityTokenReference secRef, BinarySecurity token) throws WSSecurityException {
        String tokenType;
        String valueType;
        if (secRef.containsReference()) {
            valueType = secRef.getReference().getValueType();
            if (token instanceof X509Security && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(valueType)) {
                throw new WSSecurityException(4, "invalidValueType", new Object[]{valueType});
            }
            if (token instanceof PKIPathSecurity && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1".equals(valueType)) {
                throw new WSSecurityException(4, "invalidValueType", new Object[]{valueType});
            }
        } else if (secRef.containsKeyIdentifier() && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(valueType = secRef.getKeyIdentifierValueType()) && !"http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1".equals(valueType)) {
            throw new WSSecurityException(4, "invalidValueType", new Object[]{valueType});
        }
        if (token instanceof PKIPathSecurity && !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1".equals(tokenType = secRef.getTokenType())) {
            throw new WSSecurityException(4, "invalidTokenType", new Object[]{tokenType});
        }
    }

    public static void checkEncryptedKeyBSPCompliance(SecurityTokenReference secRef) throws WSSecurityException {
        String valueType;
        if (secRef.containsKeyIdentifier() && !"http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(valueType = secRef.getKeyIdentifierValueType())) {
            throw new WSSecurityException(4, "invalidValueType", new Object[]{valueType});
        }
        String tokenType = secRef.getTokenType();
        if (!"http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey".equals(tokenType)) {
            throw new WSSecurityException(4, "invalidTokenType", new Object[]{tokenType});
        }
    }

    public static void checkSamlTokenBSPCompliance(SecurityTokenReference secRef, AssertionWrapper assertion) throws WSSecurityException {
        String valueType;
        if (secRef.containsKeyIdentifier()) {
            String valueType2 = secRef.getKeyIdentifierValueType();
            if (assertion.getSaml1() != null && !"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType2)) {
                throw new WSSecurityException(4, "invalidValueType", new Object[]{valueType2});
            }
            if (assertion.getSaml2() != null && !"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(valueType2)) {
                throw new WSSecurityException(4, "invalidValueType", new Object[]{valueType2});
            }
            String encoding = secRef.getKeyIdentifierEncodingType();
            if (encoding != null && !"".equals(encoding)) {
                throw new WSSecurityException(4, "badEncodingType", new Object[]{encoding});
            }
        }
        String tokenType = secRef.getTokenType();
        if (assertion.getSaml1() != null && !"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
            throw new WSSecurityException(4, "invalidTokenType", new Object[]{tokenType});
        }
        if (assertion.getSaml2() != null && !"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType)) {
            throw new WSSecurityException(4, "invalidTokenType", new Object[]{tokenType});
        }
        if (assertion.getSaml2() != null && secRef.containsReference() && (valueType = secRef.getReference().getValueType()) != null && !"".equals(valueType)) {
            throw new WSSecurityException(4, "invalidValueType", new Object[]{valueType});
        }
    }

    public static void checkUsernameTokenBSPCompliance(SecurityTokenReference secRef) throws WSSecurityException {
        if (!secRef.containsReference()) {
            throw new WSSecurityException(6, "unsupportedKeyId");
        }
        String valueType = secRef.getReference().getValueType();
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken".equals(valueType)) {
            throw new WSSecurityException(3, "invalidValueType", new Object[]{valueType});
        }
    }
}

