/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.validate;

import java.util.List;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.SignatureTrustValidator;

public class SamlAssertionValidator
extends SignatureTrustValidator {
    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || credential.getAssertion() == null) {
            throw new WSSecurityException(0, "noCredential");
        }
        AssertionWrapper assertion = credential.getAssertion();
        String confirmMethod = null;
        List<String> methods = assertion.getConfirmationMethods();
        if (methods != null && methods.size() > 0) {
            confirmMethod = methods.get(0);
        }
        if (OpenSAMLUtil.isMethodHolderOfKey(confirmMethod)) {
            if (assertion.getSubjectKeyInfo() == null) {
                throw new WSSecurityException(0, "noKeyInSAMLToken");
            }
            if (!assertion.isSigned()) {
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
        if (assertion.isSigned()) {
            this.verifySignedAssertion(assertion, data);
        }
        return credential;
    }

    protected Credential verifySignedAssertion(AssertionWrapper assertion, RequestData data) throws WSSecurityException {
        Credential trustCredential = new Credential();
        SAMLKeyInfo samlKeyInfo = assertion.getSignatureKeyInfo();
        trustCredential.setPublicKey(samlKeyInfo.getPublicKey());
        trustCredential.setCertificates(samlKeyInfo.getCerts());
        return super.validate(trustCredential, data);
    }
}

