/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.transform;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.transform.STRTransformUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.jcp.xml.dsig.internal.dom.ApacheData;
import org.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class STRTransform
extends TransformService {
    public static final String TRANSFORM_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    public static final String TRANSFORM_WS_DOC_INFO = "transform_ws_doc_info";
    private TransformParameterSpec params;
    private Element transformElement;
    private static Log log = LogFactory.getLog(STRTransform.class);
    private static boolean doDebug = false;

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    public void init(TransformParameterSpec params) throws InvalidAlgorithmParameterException {
        this.params = params;
    }

    public void init(XMLStructure parent, XMLCryptoContext context) throws InvalidAlgorithmParameterException {
        if (context != null && !(context instanceof DOMCryptoContext)) {
            throw new ClassCastException("context must be of type DOMCryptoContext");
        }
        this.transformElement = (Element)((DOMStructure)parent).getNode();
    }

    public void marshalParams(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        if (context != null && !(context instanceof DOMCryptoContext)) {
            throw new ClassCastException("context must be of type DOMCryptoContext");
        }
        Element transformElement2 = (Element)((DOMStructure)parent).getNode();
        DOMUtils.appendChild(transformElement2, this.transformElement);
        this.transformElement = transformElement2;
    }

    public Data transform(Data data, XMLCryptoContext xc) throws TransformException {
        if (data == null) {
            throw new NullPointerException("data must not be null");
        }
        return this.transformIt(data, xc, null);
    }

    public Data transform(Data data, XMLCryptoContext xc, OutputStream os) throws TransformException {
        if (data == null) {
            throw new NullPointerException("data must not be null");
        }
        if (os == null) {
            throw new NullPointerException("output stream must not be null");
        }
        return this.transformIt(data, xc, os);
    }

    private Data transformIt(Data data, XMLCryptoContext xc, OutputStream os) throws TransformException {
        doDebug = log.isDebugEnabled();
        String canonAlgo = null;
        Element transformParams = WSSecurityUtil.getDirectChildElement(this.transformElement, "TransformationParameters", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (transformParams != null) {
            Element canonElem = WSSecurityUtil.getDirectChildElement(transformParams, "CanonicalizationMethod", "http://www.w3.org/2000/09/xmldsig#");
            canonAlgo = canonElem.getAttribute("Algorithm");
        }
        try {
            String type;
            XMLSignatureInput xmlSignatureInput = null;
            if (data instanceof ApacheData) {
                xmlSignatureInput = ((ApacheData)data).getXMLSignatureInput();
            } else if (data instanceof DOMSubTreeData) {
                DOMSubTreeData subTree = (DOMSubTreeData)data;
                xmlSignatureInput = new XMLSignatureInput(subTree.getRoot());
                xmlSignatureInput.setExcludeComments(subTree.excludeComments());
            } else {
                try {
                    xmlSignatureInput = new XMLSignatureInput(((OctetStreamData)data).getOctetStream());
                }
                catch (Exception ex) {
                    throw new TransformException(ex);
                }
            }
            if (!xmlSignatureInput.isElement()) {
                throw new TransformException("Wrong input format - only element input supported");
            }
            Element str = (Element)xmlSignatureInput.getSubNode();
            SecurityTokenReference secRef = new SecurityTokenReference(str);
            Canonicalizer canon = Canonicalizer.getInstance((String)canonAlgo);
            ByteArrayOutputStream bos = null;
            byte[] buf = null;
            WSDocInfo wsDocInfo = (WSDocInfo)xc.getProperty(TRANSFORM_WS_DOC_INFO);
            if (wsDocInfo == null) {
                throw new TransformException("no WSDocInfo found");
            }
            Document doc = str.getOwnerDocument();
            Element dereferencedToken = STRTransformUtil.dereferenceSTR(doc, secRef, wsDocInfo);
            if (dereferencedToken != null && ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(type = dereferencedToken.getAttribute("ValueType")) || PKIPathSecurity.getType().equals(type))) {
                WSSecurityUtil.setNamespace(dereferencedToken, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
                WSSecurityUtil.setNamespace(dereferencedToken, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
            }
            buf = canon.canonicalizeSubtree((Node)dereferencedToken, "#default");
            if (doDebug) {
                bos = new ByteArrayOutputStream(buf.length);
                bos.write(buf, 0, buf.length);
                log.debug((Object)("after c14n: " + bos.toString()));
            }
            StringBuilder bf = new StringBuilder(new String(buf));
            String bf1 = bf.toString();
            int gt = bf1.indexOf(">");
            int idx = bf1.indexOf("xmlns=");
            if (idx < 0 || idx > gt) {
                idx = bf1.indexOf(" ");
                bf.insert(idx + 1, "xmlns=\"\" ");
                bf1 = bf.toString();
            }
            if (doDebug) {
                log.debug((Object)"last result: ");
                log.debug((Object)bf1);
            }
            XMLSignatureInput output = new XMLSignatureInput(bf1.getBytes());
            if (os != null) {
                output.updateOutputStream(os);
                return null;
            }
            return new OctetStreamData(output.getOctetStream());
        }
        catch (Exception ex) {
            throw new TransformException(ex);
        }
    }

    public final boolean isFeatureSupported(String feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        return false;
    }
}

