/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.xml;

import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.ts.xml.MessageContent;
import org.apache.axiom.ts.xml.MessageSample;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.field.ContentTypeFieldLenientImpl;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.RawField;

public abstract class MIMESample
extends MessageSample {
    private final String contentType;
    private Multipart multipart;

    protected MIMESample(MessageContent content, String name, String contentType) {
        super(content, name);
        this.contentType = contentType;
    }

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    private String getParameter(String name) {
        return ((ContentTypeField)ContentTypeFieldLenientImpl.PARSER.parse((Field)new RawField("Content-Type", this.contentType), DecodeMonitor.SILENT)).getParameter(name);
    }

    public final String getStart() {
        String start = this.getParameter("start");
        if (start.startsWith("<") && start.endsWith(">")) {
            return start.substring(1, start.length() - 1);
        }
        return start;
    }

    public final String getBoundary() {
        return this.getParameter("boundary");
    }

    private final synchronized Multipart getMultipart() {
        if (this.multipart == null) {
            try {
                DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
                defaultMessageBuilder.setMimeEntityConfig(MimeConfig.custom().setHeadlessParsing(this.contentType).build());
                defaultMessageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
                this.multipart = (Multipart)defaultMessageBuilder.parseMessage(this.getInputStream()).getBody();
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
        }
        return this.multipart;
    }

    public final InputStream getPart(int part) {
        try {
            return ((SingleBody)((Entity)this.getMultipart().getBodyParts().get(part)).getBody()).getInputStream();
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    public final InputStream getPart(String cid) {
        try {
            Multipart mp = this.getMultipart();
            for (Entity entity : mp.getBodyParts()) {
                Field contentId = entity.getHeader().getField("Content-ID");
                if (contentId == null || !contentId.getBody().equals(cid) && !contentId.getBody().equals("<" + cid + ">")) continue;
                return ((SingleBody)entity.getBody()).getInputStream();
            }
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        throw new IllegalArgumentException("Part " + cid + " not found");
    }
}

