/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.xml;

import java.io.InputStream;
import java.net.URL;
import org.apache.axiom.ts.xml.URLMessageContent;

public abstract class MessageContent {
    public static MessageContent fromURL(URL url) {
        return new URLMessageContent(url);
    }

    public static MessageContent fromClasspath(Class<?> clazz, String relativeResourceName) {
        URL url = clazz.getResource(relativeResourceName);
        if (url == null) {
            throw new IllegalArgumentException(String.format("No such resource: %s (relative to %s)", relativeResourceName, clazz.getName()));
        }
        return MessageContent.fromURL(url);
    }

    public static MessageContent fromClasspath(ClassLoader classLoader, String resourceName) {
        URL url = classLoader.getResource(resourceName);
        if (url == null) {
            throw new IllegalArgumentException(String.format("No such resource: %s", resourceName));
        }
        return MessageContent.fromURL(url);
    }

    MessageContent() {
    }

    public abstract InputStream getInputStream();

    public abstract URL getURL();
}

