/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.apache.axiom.ts.xml.MessageContent;
import org.apache.axiom.ts.xml.MessageSample;

public abstract class MIMESample
extends MessageSample {
    private final String contentType;
    private MimeMultipart multipart;

    protected MIMESample(MessageContent content, String contentType) {
        super(content);
        this.contentType = contentType;
    }

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    private String getParameter(String name) {
        try {
            return new ContentType(this.contentType).getParameter(name);
        }
        catch (ParseException ex) {
            throw new Error(ex);
        }
    }

    public final String getStart() {
        String start = this.getParameter("start");
        if (start.startsWith("<") && start.endsWith(">")) {
            return start.substring(1, start.length() - 1);
        }
        return start;
    }

    public final String getBoundary() {
        return this.getParameter("boundary");
    }

    protected final synchronized MimeMultipart getMultipart() {
        if (this.multipart == null) {
            try {
                this.multipart = new MimeMultipart(new DataSource(){

                    public OutputStream getOutputStream() throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public String getName() {
                        return null;
                    }

                    public InputStream getInputStream() throws IOException {
                        return MIMESample.this.getInputStream();
                    }

                    public String getContentType() {
                        return MIMESample.this.getContentType();
                    }
                });
                this.multipart.getCount();
            }
            catch (MessagingException ex) {
                throw new Error(ex);
            }
        }
        return this.multipart;
    }

    public final InputStream getPart(int part) {
        try {
            return this.getMultipart().getBodyPart(part).getInputStream();
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        catch (MessagingException ex) {
            throw new Error(ex);
        }
    }

    public final InputStream getPart(String cid) {
        try {
            MimeMultipart mp = this.getMultipart();
            BodyPart part = mp.getBodyPart(cid);
            if (part == null) {
                part = mp.getBodyPart("<" + cid + ">");
            }
            if (part == null) {
                throw new IllegalArgumentException("Part " + cid + " not found");
            }
            return part.getInputStream();
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        catch (MessagingException ex) {
            throw new Error(ex);
        }
    }
}

