/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;

public class InvocationCounter {
    final AtomicInteger invocationCount = new AtomicInteger();
    final AtomicInteger exceptionCount = new AtomicInteger();

    public Object createProxy(Object target) {
        HashSet ifaces = new HashSet();
        Class<?> clazz = target.getClass();
        do {
            ifaces.addAll(Arrays.asList(clazz.getInterfaces()));
        } while ((clazz = clazz.getSuperclass()) != null);
        return Proxy.newProxyInstance(InvocationCounter.class.getClassLoader(), ifaces.toArray(new Class[ifaces.size()]), (InvocationHandler)new InvocationHandlerImpl(target));
    }

    public int getInvocationCount() {
        return this.invocationCount.get();
    }

    public int getExceptionCount() {
        return this.exceptionCount.get();
    }

    public void reset() {
        this.invocationCount.set(0);
        this.exceptionCount.set(0);
    }

    private class InvocationHandlerImpl
    implements InvocationHandler {
        private final Object target;

        public InvocationHandlerImpl(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            InvocationCounter.this.invocationCount.incrementAndGet();
            try {
                return method.invoke(this.target, args);
            }
            catch (InvocationTargetException ex) {
                InvocationCounter.this.exceptionCount.incrementAndGet();
                throw ex.getCause();
            }
        }
    }
}

