/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.activation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.activation.DataSource;
import org.apache.commons.io.input.ReaderInputStream;

public class TextDataSource
implements DataSource {
    private final String content;
    private final String charset;
    private final String subtype;

    public TextDataSource(String content, String charset, String subtype) {
        this.content = content;
        this.charset = charset;
        this.subtype = subtype;
    }

    public String getContentType() {
        return "text/" + this.subtype + "; charset='" + this.charset + "'";
    }

    public InputStream getInputStream() throws IOException {
        return new ReaderInputStream((Reader)new StringReader(this.content), this.charset);
    }

    public String getName() {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }
}

