/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.springws;

import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.springws.MatrixTestCasePropertySource;
import org.apache.axiom.ts.springws.MessageFactoryConfigurator;
import org.apache.axiom.ts.springws.SOAPSpecAdapter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public abstract class SpringWSTestCase
extends MatrixTestCase {
    protected final SOAPSpec spec;

    public SpringWSTestCase(SOAPSpec spec) {
        this.spec = spec;
        this.addTestParameter("soapVersion", ((SOAPSpecAdapter)spec.getAdapter(SOAPSpecAdapter.class)).getSoapVersion());
    }

    protected void configureContext(GenericApplicationContext context, MessageFactoryConfigurator messageFactoryConfigurator, Resource configResource) {
        context.getEnvironment().getPropertySources().addFirst((PropertySource)new MatrixTestCasePropertySource(this));
        messageFactoryConfigurator.configure(context);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)context);
        reader.loadBeanDefinitions((Resource)new ClassPathResource("common.xml", SpringWSTestCase.class));
        if (configResource != null) {
            reader.loadBeanDefinitions(configResource);
        }
    }
}

