/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.springws.scenario.broker;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.ts.springws.scenario.broker.CustomerService;
import org.apache.axiom.ts.springws.scenario.broker.OrderStatus;
import org.apache.axiom.ts.springws.scenario.broker.UnknownCustomerException;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.Namespace;
import org.springframework.ws.server.endpoint.annotation.Namespaces;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.RequestPayload;
import org.springframework.ws.server.endpoint.annotation.ResponsePayload;
import org.springframework.ws.server.endpoint.annotation.XPathParam;
import org.springframework.xml.transform.TransformerHelper;

@Endpoint
public class BrokerEndpoint {
    private final CustomerService customerService;
    private final TransformerHelper transformerHelper = new TransformerHelper();
    private final Deque<String> orderQueue = new LinkedList<String>();

    public BrokerEndpoint(CustomerService customerService) {
        this.customerService = customerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PayloadRoot(namespace="urn:broker", localPart="Order")
    @ResponsePayload
    @Namespaces(value={@Namespace(prefix="p", uri="urn:broker")})
    public OrderStatus order(@XPathParam(value="/p:Order/p:Customer") Integer customer, @RequestPayload Source payloadSource) throws UnknownCustomerException, TransformerException {
        this.customerService.validateCustomer(customer);
        StringWriter sw = new StringWriter();
        this.transformerHelper.transform(payloadSource, (Result)new StreamResult(sw));
        String payload = sw.toString();
        Deque<String> deque = this.orderQueue;
        synchronized (deque) {
            this.orderQueue.addLast(payload);
            this.orderQueue.notify();
        }
        OrderStatus status = new OrderStatus();
        status.setReceived(new Date());
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PayloadRoot(namespace="urn:broker", localPart="RetrieveNextOrder")
    @ResponsePayload
    public Source retrieveNextOrder() throws InterruptedException {
        Deque<String> deque = this.orderQueue;
        synchronized (deque) {
            while (this.orderQueue.isEmpty()) {
                this.orderQueue.wait();
            }
            return new StreamSource(new StringReader(this.orderQueue.removeFirst()));
        }
    }
}

