/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.saaj.element;

import com.google.common.truth.Truth;
import javax.xml.soap.SOAPElement;
import org.apache.axiom.ts.saaj.SAAJImplementation;
import org.apache.axiom.ts.saaj.SAAJTestCase;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

public class TestAddChildElementLocalNamePrefixAndURI
extends SAAJTestCase {
    public TestAddChildElementLocalNamePrefixAndURI(SAAJImplementation saajImplementation, SOAPSpec spec) {
        super(saajImplementation, spec);
    }

    protected void runTest() throws Throwable {
        SOAPElement root = this.newSOAPFactory().createElement("root", "ns1", "urn:ns1");
        SOAPElement element = root.addChildElement("child", "ns2", "urn:ns2");
        Truth.assertThat((String)element.getLocalName()).isEqualTo((Object)"child");
        Truth.assertThat((String)element.getNamespaceURI()).isEqualTo((Object)"urn:ns2");
        Truth.assertThat((String)element.getPrefix()).isEqualTo((Object)"ns2");
        Truth.assertThat((Object)element.getParentNode()).isSameAs((Object)root);
        NamedNodeMap attributes = element.getAttributes();
        Truth.assertThat((Integer)attributes.getLength()).isEqualTo((Object)1);
        Attr attr = (Attr)attributes.item(0);
        Truth.assertThat((String)attr.getNamespaceURI()).isEqualTo((Object)"http://www.w3.org/2000/xmlns/");
        Truth.assertThat((String)attr.getPrefix()).isEqualTo((Object)"xmlns");
        Truth.assertThat((String)attr.getLocalName()).isEqualTo((Object)"ns2");
    }
}

