/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.saaj;

import java.lang.reflect.Method;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SAAJMetaFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;

public final class SAAJImplementation {
    private static final Method newMessageFactoryMethod;
    private static final Method newSOAPFactoryMethod;
    private final SAAJMetaFactory metaFactory;

    public SAAJImplementation(SAAJMetaFactory metaFactory) {
        this.metaFactory = metaFactory;
    }

    public MessageFactory newMessageFactory(String protocol) throws SOAPException {
        try {
            return (MessageFactory)newMessageFactoryMethod.invoke((Object)this.metaFactory, protocol);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public SOAPFactory newSOAPFactory(String protocol) throws SOAPException {
        try {
            return (SOAPFactory)newSOAPFactoryMethod.invoke((Object)this.metaFactory, protocol);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    static {
        try {
            newMessageFactoryMethod = SAAJMetaFactory.class.getDeclaredMethod("newMessageFactory", String.class);
            newMessageFactoryMethod.setAccessible(true);
            newSOAPFactoryMethod = SAAJMetaFactory.class.getDeclaredMethod("newSOAPFactory", String.class);
            newSOAPFactoryMethod.setAccessible(true);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

