/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.intf;

import java.io.IOException;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.blob.BlobDataSource;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CloneableCharacterData;
import org.apache.axiom.core.stream.CharacterData;
import org.apache.axiom.core.stream.CharacterDataSink;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMException;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axiom.util.base64.AbstractBase64EncodingOutputStream;
import org.apache.axiom.util.base64.Base64EncodingStringBufferOutputStream;
import org.apache.axiom.util.base64.Base64Utils;

public final class TextContent
implements CloneableCharacterData {
    private final String value;
    private final String mimeType;
    private String contentID;
    private Object dataHandlerObject;
    private boolean optimize;
    private boolean binary;

    public TextContent(String value) {
        this.value = value;
        this.mimeType = null;
    }

    public TextContent(String value, String mimeType, boolean optimize) {
        this.value = value;
        this.mimeType = mimeType;
        this.binary = true;
        this.optimize = optimize;
    }

    public TextContent(String contentID, Object dataHandlerObject, boolean optimize) {
        this.value = null;
        this.mimeType = null;
        this.contentID = contentID;
        this.dataHandlerObject = dataHandlerObject;
        this.binary = true;
        this.optimize = optimize;
    }

    private TextContent(TextContent other) {
        this.value = other.value;
        this.mimeType = other.mimeType;
        this.contentID = other.contentID;
        this.dataHandlerObject = other.dataHandlerObject;
        this.optimize = other.optimize;
        this.binary = other.binary;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
        if (optimize) {
            this.binary = true;
        }
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public String getContentID() {
        if (this.contentID == null) {
            this.contentID = UIDGenerator.generateContentId();
        }
        return this.contentID;
    }

    public void setContentID(String contentID) {
        this.contentID = contentID;
    }

    public Object getDataHandlerObject() {
        return this.dataHandlerObject;
    }

    public DataHandler getDataHandler() {
        if (this.dataHandlerObject != null) {
            if (this.dataHandlerObject instanceof DataHandlerProvider) {
                try {
                    this.dataHandlerObject = ((DataHandlerProvider)this.dataHandlerObject).getDataHandler();
                }
                catch (IOException ex) {
                    throw new OMException((Throwable)ex);
                }
            }
            return (DataHandler)this.dataHandlerObject;
        }
        if (this.binary) {
            return new DataHandler((DataSource)new BlobDataSource(Blobs.createBlob((byte[])Base64Utils.decode((String)this.value)), this.mimeType));
        }
        throw new OMException("No DataHandler available");
    }

    public String toString() {
        if (this.dataHandlerObject != null) {
            try {
                return Base64Utils.encode((DataHandler)this.getDataHandler());
            }
            catch (Exception e) {
                throw new OMException((Throwable)e);
            }
        }
        return this.value;
    }

    public char[] toCharArray() {
        if (this.dataHandlerObject != null) {
            try {
                return Base64Utils.encodeToCharArray((DataHandler)this.getDataHandler());
            }
            catch (IOException ex) {
                throw new OMException((Throwable)ex);
            }
        }
        return this.value.toCharArray();
    }

    public <T> CharacterData clone(ClonePolicy<T> policy, T options) {
        if (this.binary && options instanceof OMCloneOptions && ((OMCloneOptions)options).isFetchDataHandlers()) {
            this.getDataHandler().getDataSource();
        }
        return new TextContent(this);
    }

    public void writeTo(CharacterDataSink sink) throws IOException {
        if (this.binary) {
            AbstractBase64EncodingOutputStream out = sink.getBase64EncodingOutputStream();
            this.getDataHandler().writeTo((OutputStream)out);
            out.complete();
        } else {
            sink.getWriter().write(this.value);
        }
    }

    public void appendTo(StringBuilder buffer) {
        if (this.binary) {
            Base64EncodingStringBufferOutputStream out = new Base64EncodingStringBufferOutputStream(buffer);
            try {
                this.getDataHandler().writeTo((OutputStream)out);
                out.complete();
            }
            catch (IOException ex) {
                throw new OMException((Throwable)ex);
            }
        } else {
            buffer.append(this.value);
        }
    }
}

