/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common;

import org.apache.axiom.core.AttributeMatcher;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.DetachPolicy;
import org.apache.axiom.core.NSAwareAttributeMatcher;
import org.apache.axiom.core.NamespaceDeclarationMatcher;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.core.Semantics;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.NSUtil;
import org.apache.axiom.om.impl.intf.AxiomAttribute;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomSourcedElement;
import org.apache.axiom.om.impl.mixin.AxiomNamedInformationItemSupport;

public final class AxiomSemantics
implements Semantics {
    public static final AxiomSemantics INSTANCE = new AxiomSemantics();
    public static final AttributeMatcher ATTRIBUTE_MATCHER = new NSAwareAttributeMatcher((Semantics)INSTANCE, false, false);
    public static final AttributeMatcher NAMESPACE_DECLARATION_MATCHER = new NamespaceDeclarationMatcher((Semantics)INSTANCE);
    public static final ClonePolicy<OMCloneOptions> CLONE_POLICY = new ClonePolicy<OMCloneOptions>(){

        public Class<? extends CoreNode> getTargetNodeClass(OMCloneOptions options, CoreNode node) {
            if (options != null && options.isPreserveModel()) {
                return node.coreGetNodeClass();
            }
            if (options != null && options.isCopyOMDataSources() && node instanceof AxiomSourcedElement) {
                return AxiomSourcedElement.class;
            }
            return node.coreGetNodeType().getInterface();
        }

        public boolean repairNamespaces(OMCloneOptions options) {
            return true;
        }

        public boolean cloneAttributes(OMCloneOptions options) {
            return true;
        }

        public boolean cloneChildren(OMCloneOptions options, NodeType nodeType) {
            return true;
        }

        public void postProcess(OMCloneOptions options, CoreNode clone) {
            if (clone instanceof AxiomElement && ((AxiomElement)clone).isExpanded()) {
                AxiomElement element = (AxiomElement)clone;
                NSUtil.handleNamespace(element, AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$getNamespace(element), false, true);
                CoreAttribute attr = element.coreGetFirstAttribute();
                while (attr != null) {
                    if (attr instanceof AxiomAttribute) {
                        NSUtil.handleNamespace(element, AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$getNamespace((AxiomAttribute)attr), true, true);
                    }
                    attr = attr.coreGetNextAttribute();
                }
            }
        }
    };

    private AxiomSemantics() {
    }

    public DetachPolicy getDetachPolicy() {
        return DetachPolicy.NEW_DOCUMENT;
    }

    public boolean isUseStrictNamespaceLookup() {
        return true;
    }

    public boolean isParentNode(NodeType nodeType) {
        return nodeType == NodeType.DOCUMENT || nodeType == NodeType.NS_AWARE_ELEMENT;
    }

    public RuntimeException toUncheckedException(CoreModelException ex) {
        return AxiomExceptionTranslator.translate(ex);
    }
}

