/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.fom.attribute;

import com.google.common.truth.Truth;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Element;
import org.apache.axiom.ts.fom.AbderaTestCase;

public class TestSetAttributeValueQNameNew
extends AbderaTestCase {
    private final QName qname;

    public TestSetAttributeValueQNameNew(Abdera abdera, QName qname) {
        super(abdera);
        this.qname = qname;
        this.addTestParameter("qname", qname.toString());
        this.addTestParameter("prefix", qname.getPrefix());
    }

    protected void runTest() throws Throwable {
        Element element = this.abdera.getFactory().newElement(new QName("test"));
        element.setAttributeValue(this.qname, "value");
        Truth.assertThat((String)element.getAttributeValue(this.qname)).isEqualTo((Object)"value");
        List attrs = element.getAttributes();
        Truth.assertThat((Iterable)attrs).hasSize(1);
        QName actualQName = (QName)attrs.get(0);
        Truth.assertThat((Object)actualQName).isEqualTo((Object)this.qname);
        Truth.assertThat((String)actualQName.getPrefix()).isEqualTo((Object)this.qname.getPrefix());
    }
}

