/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.domts;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import org.apache.axiom.ts.dom.ResolveURI;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.domts.DOMTestDocumentBuilderFactory;
import org.w3c.domts.DOMTestIncompatibleException;
import org.w3c.domts.DOMTestLoadException;
import org.w3c.domts.DocumentBuilderSetting;

public abstract class DOMTest {
    private DOMTestDocumentBuilderFactory factory;
    private int mutationCount = 0;

    public DOMTest(DOMTestDocumentBuilderFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
    }

    public DOMTest() {
        this.factory = null;
    }

    protected void setFactory(DOMTestDocumentBuilderFactory factory) {
        this.factory = factory;
    }

    public boolean hasFeature(String feature, String version) {
        return this.factory.hasFeature(feature, version);
    }

    public boolean hasSetting(DocumentBuilderSetting setting) {
        return setting.hasSetting(this.factory);
    }

    protected DOMTestDocumentBuilderFactory getFactory() {
        return this.factory;
    }

    public DOMImplementation getImplementation() {
        return this.factory.getDOMImplementation();
    }

    private URL resolveURI(String baseURI) throws DOMTestLoadException {
        String string = baseURI;
        return DOMTest.resolveURI_aroundBody1$advice(this, string, ResolveURI.aspectOf(), this, string, null);
    }

    public String getResourceURI(String href, String scheme, String contentType) throws DOMTestLoadException {
        if (scheme == null) {
            throw new NullPointerException("scheme");
        }
        if ("file".equals(scheme)) {
            return this.resolveURI(href).toString();
        }
        if ("http".equals(scheme)) {
            StringBuffer httpURL = new StringBuffer(System.getProperty("org.w3c.domts.httpbase", "http://localhost:8080/webdav/"));
            httpURL.append(href);
            if ("application/pdf".equals(contentType)) {
                httpURL.append(".pdf");
            } else {
                httpURL.append(".xml");
            }
            return httpURL.toString();
        }
        throw new DOMTestLoadException(new Exception("Unrecognized URI scheme " + scheme));
    }

    public String createTempURI(String scheme) throws DOMTestLoadException {
        if (scheme == null) {
            throw new NullPointerException("scheme");
        }
        if ("file".equals(scheme)) {
            try {
                File tempFile = File.createTempFile("domts", ".xml");
                try {
                    Method method = File.class.getMethod("toURI", null);
                    Object uri = method.invoke((Object)tempFile, null);
                    return uri.toString();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    URL url = tempFile.toURL();
                    return url.toString();
                }
            }
            catch (Exception ex) {
                throw new DOMTestLoadException(ex);
            }
        }
        if ("http".equals(scheme)) {
            String httpBase = System.getProperty("org.w3c.domts.httpbase", "http://localhost:8080/webdav/");
            StringBuffer buf = new StringBuffer(httpBase);
            if (!httpBase.endsWith("/")) {
                buf.append("/");
            }
            buf.append("tmp");
            buf.append(new Random().nextInt(Integer.MAX_VALUE));
            buf.append(".xml");
            return buf.toString();
        }
        throw new DOMTestLoadException(new Exception("Unrecognized URI scheme " + scheme));
    }

    public Document load(String docURI, boolean willBeModified) throws DOMTestLoadException {
        Document doc = this.factory.load(this.resolveURI(docURI));
        return doc;
    }

    public void preload(String contentType, String docURI, boolean willBeModified) throws DOMTestIncompatibleException {
        if (("text/html".equals(contentType) || "application/xhtml+xml".equals(contentType)) && (docURI.startsWith("staff") || docURI.equals("datatype_normalization"))) {
            throw DOMTestIncompatibleException.incompatibleLoad(docURI, contentType);
        }
    }

    public Object createXPathEvaluator(Document doc) {
        return this.factory.createXPathEvaluator(doc);
    }

    public InputStream createStream(String bytes) throws DOMTestLoadException, IOException {
        int byteCount = bytes.length() / 2;
        byte[] array = new byte[byteCount];
        int i = 0;
        while (i < byteCount) {
            array[i] = Byte.parseByte(bytes.substring(i * 2, i * 2 + 2), 16);
            ++i;
        }
        return new ByteArrayInputStream(array);
    }

    public abstract String getTargetURI();

    public final boolean isCoalescing() {
        return this.factory.isCoalescing();
    }

    public final boolean isExpandEntityReferences() {
        return this.factory.isExpandEntityReferences();
    }

    public final boolean isIgnoringElementContentWhitespace() {
        return this.factory.isIgnoringElementContentWhitespace();
    }

    public final boolean isNamespaceAware() {
        return this.factory.isNamespaceAware();
    }

    public final boolean isValidating() {
        return this.factory.isValidating();
    }

    public final boolean isSigned() {
        return true;
    }

    public final boolean isHasNullString() {
        return true;
    }

    public final String getContentType() {
        return this.factory.getContentType();
    }

    public final int getMutationCount() {
        return this.mutationCount;
    }

    public static /* synthetic */ void ajc$set$factory(DOMTest dOMTest, DOMTestDocumentBuilderFactory dOMTestDocumentBuilderFactory) {
        dOMTest.factory = dOMTestDocumentBuilderFactory;
    }

    private static final /* synthetic */ URL resolveURI_aroundBody0(DOMTest ajc$this, String baseURI) {
        String docURI = ajc$this.factory.addExtension(baseURI);
        URL resolvedURI = null;
        try {
            resolvedURI = new URL(docURI);
            if (resolvedURI.getProtocol() != null) {
                return resolvedURI;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        resolvedURI = ajc$this.getClass().getResource("/" + docURI);
        if (resolvedURI == null) {
            int firstSlash = docURI.indexOf(47);
            try {
                if (firstSlash == 0 || firstSlash >= 1 && docURI.charAt(firstSlash - 1) == ':') {
                    resolvedURI = new URL(docURI);
                } else {
                    String filename = ajc$this.getClass().getPackage().getName();
                    filename = "tests/" + filename.substring(14).replace('.', '/') + "/files/" + docURI;
                    resolvedURI = new File(filename).toURL();
                }
            }
            catch (MalformedURLException ex) {
                throw new DOMTestLoadException(ex);
            }
        }
        if (resolvedURI == null) {
            throw new DOMTestLoadException(new FileNotFoundException(docURI));
        }
        return resolvedURI;
    }

    private static final /* synthetic */ URL resolveURI_aroundBody1$advice(DOMTest ajc$this, String baseURI, ResolveURI ajc$aspectInstance, DOMTest test, String baseURI2, AroundClosure ajc$aroundClosure) {
        String resourceName;
        String docURI = test.factory.addExtension(baseURI2);
        Class<?> testClass = test.getClass();
        URL url = testClass.getResource(resourceName = "/" + testClass.getPackage().getName().replace('.', '/') + "/" + docURI);
        if (url == null) {
            throw new DOMTestLoadException("Resource " + resourceName + " not found");
        }
        return url;
    }
}

