/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.element;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.apache.axiom.ts.dom.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class TestSetAttributeNS
extends DOMTestCase {
    private final QName qname;
    private final String value;

    public TestSetAttributeNS(DocumentBuilderFactory dbf, QName qname, String value) {
        super(dbf);
        this.qname = qname;
        this.value = value;
        this.addTestParameter("ns", qname.getNamespaceURI());
        this.addTestParameter("name", DOMUtils.getQualifiedName(qname));
    }

    protected void runTest() throws Throwable {
        Document document = this.dbf.newDocumentBuilder().newDocument();
        Element element = document.createElementNS("urn:ns1", "p:element");
        element.setAttributeNS(DOMUtils.getNamespaceURI(this.qname), DOMUtils.getQualifiedName(this.qname), this.value);
        TestSetAttributeNS.assertTrue((boolean)element.hasAttributes());
        NamedNodeMap attributes = element.getAttributes();
        TestSetAttributeNS.assertEquals((int)1, (int)attributes.getLength());
        Attr attr = (Attr)attributes.item(0);
        TestSetAttributeNS.assertSame((Object)document, (Object)attr.getOwnerDocument());
        TestSetAttributeNS.assertSame((Object)element, (Object)attr.getOwnerElement());
        TestSetAttributeNS.assertEquals((String)DOMUtils.getNamespaceURI(this.qname), (String)attr.getNamespaceURI());
        TestSetAttributeNS.assertEquals((String)DOMUtils.getPrefix(this.qname), (String)attr.getPrefix());
        TestSetAttributeNS.assertEquals((String)this.qname.getLocalPart(), (String)attr.getLocalName());
        TestSetAttributeNS.assertEquals((String)DOMUtils.getQualifiedName(this.qname), (String)attr.getName());
        TestSetAttributeNS.assertEquals((String)this.value, (String)attr.getValue());
        TestSetAttributeNS.assertSame((Object)attr, (Object)element.getAttributeNodeNS(DOMUtils.getNamespaceURI(this.qname), this.qname.getLocalPart()));
    }
}

