/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.element;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestReplaceChildMiddleWithDocumentFragment
extends DOMTestCase {
    public TestReplaceChildMiddleWithDocumentFragment(DocumentBuilderFactory dbf) {
        super(dbf);
    }

    protected void runTest() throws Throwable {
        Document document = this.dbf.newDocumentBuilder().newDocument();
        DocumentFragment fragment = document.createDocumentFragment();
        Element x = document.createElementNS(null, "x");
        Element y = document.createElementNS(null, "y");
        fragment.appendChild(x);
        fragment.appendChild(y);
        Element element = document.createElementNS(null, "parent");
        Element a = document.createElementNS(null, "a");
        Element b = document.createElementNS(null, "b");
        Element c = document.createElementNS(null, "c");
        element.appendChild(a);
        element.appendChild(b);
        element.appendChild(c);
        element.replaceChild(fragment, b);
        NodeList children = element.getChildNodes();
        TestReplaceChildMiddleWithDocumentFragment.assertEquals((int)4, (int)children.getLength());
        TestReplaceChildMiddleWithDocumentFragment.assertSame((Object)a, (Object)children.item(0));
        TestReplaceChildMiddleWithDocumentFragment.assertSame((Object)x, (Object)children.item(1));
        TestReplaceChildMiddleWithDocumentFragment.assertSame((Object)y, (Object)children.item(2));
        TestReplaceChildMiddleWithDocumentFragment.assertSame((Object)c, (Object)children.item(3));
        TestReplaceChildMiddleWithDocumentFragment.assertSame((Object)element, (Object)x.getParentNode());
        TestReplaceChildMiddleWithDocumentFragment.assertSame((Object)element, (Object)y.getParentNode());
        TestReplaceChildMiddleWithDocumentFragment.assertNull((Object)fragment.getFirstChild());
        TestReplaceChildMiddleWithDocumentFragment.assertNull((Object)fragment.getLastChild());
        TestReplaceChildMiddleWithDocumentFragment.assertEquals((int)0, (int)fragment.getChildNodes().getLength());
        TestReplaceChildMiddleWithDocumentFragment.assertSame((Object)a, (Object)element.getFirstChild());
        TestReplaceChildMiddleWithDocumentFragment.assertSame((Object)c, (Object)element.getLastChild());
    }
}

