/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.element;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestReplaceChildLastWithDocumentFragment
extends DOMTestCase {
    public TestReplaceChildLastWithDocumentFragment(DocumentBuilderFactory dbf) {
        super(dbf);
    }

    protected void runTest() throws Throwable {
        Document document = this.dbf.newDocumentBuilder().newDocument();
        DocumentFragment fragment = document.createDocumentFragment();
        Element x = document.createElementNS(null, "x");
        Element y = document.createElementNS(null, "y");
        fragment.appendChild(x);
        fragment.appendChild(y);
        Element element = document.createElementNS(null, "parent");
        Element a = document.createElementNS(null, "a");
        Element b = document.createElementNS(null, "b");
        element.appendChild(a);
        element.appendChild(b);
        element.replaceChild(fragment, b);
        NodeList children = element.getChildNodes();
        TestReplaceChildLastWithDocumentFragment.assertEquals((int)3, (int)children.getLength());
        TestReplaceChildLastWithDocumentFragment.assertSame((Object)a, (Object)children.item(0));
        TestReplaceChildLastWithDocumentFragment.assertSame((Object)x, (Object)children.item(1));
        TestReplaceChildLastWithDocumentFragment.assertSame((Object)y, (Object)children.item(2));
        TestReplaceChildLastWithDocumentFragment.assertSame((Object)element, (Object)x.getParentNode());
        TestReplaceChildLastWithDocumentFragment.assertSame((Object)element, (Object)y.getParentNode());
        TestReplaceChildLastWithDocumentFragment.assertNull((Object)fragment.getFirstChild());
        TestReplaceChildLastWithDocumentFragment.assertNull((Object)fragment.getLastChild());
        TestReplaceChildLastWithDocumentFragment.assertEquals((int)0, (int)fragment.getChildNodes().getLength());
        TestReplaceChildLastWithDocumentFragment.assertSame((Object)a, (Object)element.getFirstChild());
        TestReplaceChildLastWithDocumentFragment.assertSame((Object)y, (Object)element.getLastChild());
    }
}

