/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.element;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestReplaceChildFirstWithDocumentFragment
extends DOMTestCase {
    public TestReplaceChildFirstWithDocumentFragment(DocumentBuilderFactory dbf) {
        super(dbf);
    }

    protected void runTest() throws Throwable {
        Document document = this.dbf.newDocumentBuilder().newDocument();
        DocumentFragment fragment = document.createDocumentFragment();
        Element x = document.createElementNS(null, "x");
        Element y = document.createElementNS(null, "y");
        fragment.appendChild(x);
        fragment.appendChild(y);
        Element element = document.createElementNS(null, "parent");
        Element a = document.createElementNS(null, "a");
        Element b = document.createElementNS(null, "b");
        element.appendChild(a);
        element.appendChild(b);
        element.replaceChild(fragment, a);
        NodeList children = element.getChildNodes();
        TestReplaceChildFirstWithDocumentFragment.assertEquals((int)3, (int)children.getLength());
        TestReplaceChildFirstWithDocumentFragment.assertSame((Object)x, (Object)children.item(0));
        TestReplaceChildFirstWithDocumentFragment.assertSame((Object)y, (Object)children.item(1));
        TestReplaceChildFirstWithDocumentFragment.assertSame((Object)b, (Object)children.item(2));
        TestReplaceChildFirstWithDocumentFragment.assertSame((Object)element, (Object)x.getParentNode());
        TestReplaceChildFirstWithDocumentFragment.assertSame((Object)element, (Object)y.getParentNode());
        TestReplaceChildFirstWithDocumentFragment.assertNull((Object)fragment.getFirstChild());
        TestReplaceChildFirstWithDocumentFragment.assertNull((Object)fragment.getLastChild());
        TestReplaceChildFirstWithDocumentFragment.assertEquals((int)0, (int)fragment.getChildNodes().getLength());
        TestReplaceChildFirstWithDocumentFragment.assertSame((Object)x, (Object)element.getFirstChild());
        TestReplaceChildFirstWithDocumentFragment.assertSame((Object)b, (Object)element.getLastChild());
    }
}

