/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.element;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestInsertBeforeWithDocumentFragment
extends DOMTestCase {
    public TestInsertBeforeWithDocumentFragment(DocumentBuilderFactory dbf) {
        super(dbf);
    }

    protected void runTest() throws Throwable {
        Document document = this.dbf.newDocumentBuilder().newDocument();
        DocumentFragment fragment = document.createDocumentFragment();
        Element x = document.createElementNS(null, "x");
        Element y = document.createElementNS(null, "y");
        fragment.appendChild(x);
        fragment.appendChild(y);
        Element element = document.createElementNS(null, "parent1");
        Element a = document.createElementNS(null, "a");
        Element b = document.createElementNS(null, "b");
        element.appendChild(a);
        element.appendChild(b);
        element.insertBefore(fragment, b);
        NodeList children = element.getChildNodes();
        TestInsertBeforeWithDocumentFragment.assertEquals((int)4, (int)children.getLength());
        TestInsertBeforeWithDocumentFragment.assertSame((Object)a, (Object)children.item(0));
        TestInsertBeforeWithDocumentFragment.assertSame((Object)x, (Object)children.item(1));
        TestInsertBeforeWithDocumentFragment.assertSame((Object)y, (Object)children.item(2));
        TestInsertBeforeWithDocumentFragment.assertSame((Object)b, (Object)children.item(3));
        TestInsertBeforeWithDocumentFragment.assertSame((Object)element, (Object)x.getParentNode());
        TestInsertBeforeWithDocumentFragment.assertSame((Object)element, (Object)y.getParentNode());
        TestInsertBeforeWithDocumentFragment.assertNull((Object)fragment.getFirstChild());
        TestInsertBeforeWithDocumentFragment.assertNull((Object)fragment.getLastChild());
        TestInsertBeforeWithDocumentFragment.assertEquals((int)0, (int)fragment.getChildNodes().getLength());
    }
}

