/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.element;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestCloneNodeWithAttributes
extends DOMTestCase {
    private final boolean deep;

    public TestCloneNodeWithAttributes(DocumentBuilderFactory dbf, boolean deep) {
        super(dbf);
        this.deep = deep;
        this.addTestParameter("deep", deep);
    }

    protected void runTest() throws Throwable {
        Document document = this.dbf.newDocumentBuilder().newDocument();
        Element element = document.createElementNS("urn:ns1", "p:elem");
        element.setAttributeNS(null, "attr1", "value1");
        element.setAttributeNS("urn:ns2", "q:attr2", "value2");
        Element clone = (Element)element.cloneNode(this.deep);
        TestCloneNodeWithAttributes.assertEquals((int)2, (int)clone.getAttributes().getLength());
        Attr attr1 = clone.getAttributeNodeNS(null, "attr1");
        Attr attr2 = clone.getAttributeNodeNS("urn:ns2", "attr2");
        TestCloneNodeWithAttributes.assertNotNull((Object)attr1);
        TestCloneNodeWithAttributes.assertNotNull((Object)attr2);
        TestCloneNodeWithAttributes.assertSame((Object)clone, (Object)attr1.getOwnerElement());
        TestCloneNodeWithAttributes.assertSame((Object)clone, (Object)attr2.getOwnerElement());
        TestCloneNodeWithAttributes.assertEquals((String)"value1", (String)attr1.getValue());
        TestCloneNodeWithAttributes.assertEquals((String)"value2", (String)attr2.getValue());
    }
}

