/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.element;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class TestAttributes
extends DOMTestCase {
    public TestAttributes(DocumentBuilderFactory dbf) {
        super(dbf);
    }

    protected void runTest() throws Throwable {
        Document doc = this.dbf.newDocumentBuilder().parse(TestAttributes.class.getResourceAsStream("attributetest.xml"));
        Element bodyElement = doc.getDocumentElement();
        TestAttributes.assertTrue((boolean)bodyElement.hasAttributes());
        Element directionResponse = (Element)bodyElement.getElementsByTagName("GetDirectionsResponse").item(0);
        TestAttributes.assertTrue((boolean)directionResponse.hasAttributes());
        NamedNodeMap attributes = directionResponse.getAttributes();
        Attr attr = (Attr)attributes.item(0);
        TestAttributes.assertEquals((String)"xmlns", (String)attr.getName());
        TestAttributes.assertEquals((String)"http://www.example.org/webservices/", (String)attr.getValue());
        Element directionResult = (Element)bodyElement.getElementsByTagName("GetDirectionsResult").item(0);
        TestAttributes.assertFalse((boolean)directionResult.hasAttributes());
        Element drivingDirection = (Element)directionResult.getElementsByTagName("drivingdirections").item(0);
        TestAttributes.assertTrue((boolean)drivingDirection.hasAttributes());
        attributes = drivingDirection.getAttributes();
        attr = (Attr)attributes.item(0);
        TestAttributes.assertEquals((String)"xmlns", (String)attr.getName());
        TestAttributes.assertEquals((String)"", (String)attr.getValue());
        Element route = (Element)drivingDirection.getElementsByTagName("route").item(0);
        TestAttributes.assertTrue((boolean)route.hasAttributes());
        attributes = route.getAttributes();
        attr = (Attr)attributes.item(0);
        TestAttributes.assertEquals((String)"distanceToTravel", (String)attr.getName());
        TestAttributes.assertEquals((String)"500m", (String)attr.getValue());
        attr = (Attr)attributes.item(1);
        TestAttributes.assertEquals((String)"finalStep", (String)attr.getName());
        TestAttributes.assertEquals((String)"false", (String)attr.getValue());
        attr = (Attr)attributes.item(2);
        TestAttributes.assertEquals((String)"id", (String)attr.getName());
        TestAttributes.assertEquals((String)"0", (String)attr.getValue());
    }
}

