/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.buildutils.sources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.axiom.buildutils.sources.SourceExtractor;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.utils.io.IOUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@Mojo(name="post-process-sources-jar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PostProcessMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ArtifactResolver artifactResolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("pom")) {
            return;
        }
        HashSet<String> sources = new HashSet<String>();
        try (JarInputStream in = new JarInputStream(new FileInputStream(this.project.getArtifact().getFile()));){
            JarEntry entry;
            while ((entry = in.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                new ClassReader((InputStream)in).accept((ClassVisitor)new SourceExtractor(sources, name.substring(0, name.lastIndexOf(47) + 1)), 1);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error reading jar: " + ex.getMessage(), (Exception)ex);
        }
        File sourcesJar = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "-sources.jar");
        File postProcessedSourcesJar = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "-post-processed-sources.jar");
        try (JarOutputStream out = new JarOutputStream(new FileOutputStream(postProcessedSourcesJar));){
            this.processSourceJar(sourcesJar, sources, true, out);
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            for (Artifact artifact : this.project.getArtifacts()) {
                Artifact resolvedArtifact;
                if (sources.isEmpty()) {
                    break;
                }
                if (!filter.include(artifact)) continue;
                DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
                coordinate.setGroupId(artifact.getGroupId());
                coordinate.setArtifactId(artifact.getArtifactId());
                coordinate.setVersion(artifact.getVersion());
                coordinate.setExtension("jar");
                coordinate.setClassifier("sources");
                try {
                    resolvedArtifact = this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), (ArtifactCoordinate)coordinate).getArtifact();
                }
                catch (ArtifactResolverException ex) {
                    this.getLog().warn((CharSequence)("Could not get sources for " + artifact));
                    continue;
                }
                if (!resolvedArtifact.isResolved()) continue;
                this.processSourceJar(resolvedArtifact.getFile(), sources, false, out);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error writing jar: " + ex.getMessage(), (Exception)ex);
        }
        sourcesJar.delete();
        postProcessedSourcesJar.renameTo(sourcesJar);
    }

    private void processSourceJar(File file, Set<String> sources, boolean includeAll, JarOutputStream out) throws MojoExecutionException {
        try (JarInputStream in = new JarInputStream(new FileInputStream(file));){
            JarEntry entry;
            while ((entry = in.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (!sources.remove(name) && !includeAll) continue;
                out.putNextEntry(entry);
                IOUtil.copy((InputStream)in, (OutputStream)out);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error reading " + file + ": " + ex.getMessage(), (Exception)ex);
        }
    }
}

