/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.factory;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.builder.XOPAwareStAXOMBuilder;
import org.apache.axiom.om.impl.common.factory.SAXOMXMLParserWrapper;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.MTOMStAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.util.stax.XMLEventUtils;
import org.apache.axiom.util.stax.XMLFragmentStreamReader;
import org.apache.axiom.util.stax.xop.MimePartProvider;
import org.xml.sax.InputSource;

public abstract class AbstractOMMetaFactory
implements OMMetaFactory {
    private static XMLStreamReader createXMLStreamReader(StAXParserConfiguration configuration, InputSource is) {
        try {
            if (is.getByteStream() != null) {
                String encoding = is.getEncoding();
                if (encoding == null) {
                    return StAXUtils.createXMLStreamReader((StAXParserConfiguration)configuration, (InputStream)is.getByteStream());
                }
                return StAXUtils.createXMLStreamReader((StAXParserConfiguration)configuration, (InputStream)is.getByteStream(), (String)encoding);
            }
            if (is.getCharacterStream() != null) {
                return StAXUtils.createXMLStreamReader((StAXParserConfiguration)configuration, (Reader)is.getCharacterStream());
            }
            throw new IllegalArgumentException();
        }
        catch (XMLStreamException ex) {
            throw new OMException((Throwable)ex);
        }
    }

    private static XMLStreamReader getXMLStreamReader(XMLStreamReader originalReader) {
        int eventType = originalReader.getEventType();
        switch (eventType) {
            case 7: {
                return originalReader;
            }
            case 1: {
                return new XMLFragmentStreamReader(originalReader);
            }
        }
        throw new OMException("The supplied XMLStreamReader is in an unexpected state (" + XMLEventUtils.getEventTypeString((int)eventType) + ")");
    }

    private static OMXMLParserWrapper internalCreateStAXOMBuilder(OMFactory omFactory, XMLStreamReader parser) {
        StAXOMBuilder builder = new StAXOMBuilder(omFactory, parser);
        builder.releaseParserOnClose(true);
        return builder;
    }

    public OMXMLParserWrapper createStAXOMBuilder(OMFactory omFactory, XMLStreamReader parser) {
        return AbstractOMMetaFactory.internalCreateStAXOMBuilder(omFactory, AbstractOMMetaFactory.getXMLStreamReader(parser));
    }

    public OMXMLParserWrapper createOMBuilder(OMFactory omFactory, StAXParserConfiguration configuration, InputSource is) {
        return AbstractOMMetaFactory.internalCreateStAXOMBuilder(omFactory, AbstractOMMetaFactory.createXMLStreamReader(configuration, is));
    }

    public OMXMLParserWrapper createOMBuilder(OMFactory omFactory, Source source) {
        if (source instanceof SAXSource) {
            return new SAXOMXMLParserWrapper(omFactory, (SAXSource)source);
        }
        try {
            return new StAXOMBuilder(omFactory, StAXUtils.getXMLInputFactory().createXMLStreamReader(source));
        }
        catch (XMLStreamException ex) {
            throw new OMException((Throwable)ex);
        }
    }

    public OMXMLParserWrapper createOMBuilder(StAXParserConfiguration configuration, OMFactory omFactory, InputSource rootPart, MimePartProvider mimePartProvider) {
        XOPAwareStAXOMBuilder builder = new XOPAwareStAXOMBuilder(omFactory, AbstractOMMetaFactory.createXMLStreamReader(configuration, rootPart), mimePartProvider);
        builder.releaseParserOnClose(true);
        return builder;
    }

    private SOAPModelBuilder internalCreateStAXSOAPModelBuilder(XMLStreamReader parser) {
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder((OMMetaFactory)this, parser);
        builder.releaseParserOnClose(true);
        return builder;
    }

    public SOAPModelBuilder createStAXSOAPModelBuilder(XMLStreamReader parser) {
        return this.internalCreateStAXSOAPModelBuilder(AbstractOMMetaFactory.getXMLStreamReader(parser));
    }

    public SOAPModelBuilder createSOAPModelBuilder(StAXParserConfiguration configuration, InputSource is) {
        return this.internalCreateStAXSOAPModelBuilder(AbstractOMMetaFactory.createXMLStreamReader(configuration, is));
    }

    public SOAPModelBuilder createSOAPModelBuilder(StAXParserConfiguration configuration, SOAPFactory soapFactory, InputSource rootPart, MimePartProvider mimePartProvider) {
        MTOMStAXSOAPModelBuilder builder = new MTOMStAXSOAPModelBuilder(soapFactory, AbstractOMMetaFactory.createXMLStreamReader(configuration, rootPart), mimePartProvider);
        builder.releaseParserOnClose(true);
        return builder;
    }
}

