/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.builder;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.ext.stax.datahandler.DataHandlerReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.BuilderAwareReader;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axiom.om.impl.builder.DataHandlerReaderUtils;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class StAXBuilder
implements OMXMLParserWrapper {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$axiom$om$impl$builder$StAXBuilder == null ? (class$org$apache$axiom$om$impl$builder$StAXBuilder = StAXBuilder.class$("org.apache.axiom.om.impl.builder.StAXBuilder")) : class$org$apache$axiom$om$impl$builder$StAXBuilder));
    protected XMLStreamReader parser;
    protected OMFactory omfactory;
    protected OMNode lastNode;
    protected boolean done = false;
    protected boolean cache = true;
    protected boolean parserAccessed = false;
    protected OMDocument document;
    protected String charEncoding = null;
    protected boolean _isClosed = false;
    protected boolean _releaseParserOnClose = false;
    protected CustomBuilder customBuilderForPayload = null;
    protected Map customBuilders = null;
    protected int maxDepthForCustomBuilders = -1;
    protected DataHandlerReader dataHandlerReader;
    protected int elementLevel = 0;
    protected Exception parserException;
    static /* synthetic */ Class class$org$apache$axiom$om$impl$builder$StAXBuilder;

    protected StAXBuilder(OMFactory ombuilderFactory, XMLStreamReader parser) {
        this.omfactory = ombuilderFactory;
        this.charEncoding = parser.getCharacterEncodingScheme();
        if (this.charEncoding == null) {
            this.charEncoding = parser.getEncoding();
        }
        this.initParser(parser);
    }

    protected StAXBuilder(OMFactory ombuilderFactory, XMLStreamReader parser, String characterEncoding) {
        this.omfactory = ombuilderFactory;
        this.charEncoding = characterEncoding;
        this.initParser(parser);
    }

    private void initParser(XMLStreamReader parser) {
        if (parser instanceof BuilderAwareReader) {
            ((BuilderAwareReader)((Object)parser)).setBuilder(this);
        }
        this.dataHandlerReader = DataHandlerReaderUtils.getDataHandlerReader(parser);
        this.parser = parser;
    }

    protected StAXBuilder(XMLStreamReader parser) {
        this(OMAbstractFactory.getOMFactory(), parser);
    }

    protected StAXBuilder() {
    }

    public void init(InputStream inputStream, String charSetEncoding, String url, String contentType) throws OMException {
        try {
            this.parser = StAXUtils.createXMLStreamReader(inputStream);
        }
        catch (XMLStreamException e1) {
            throw new OMException(e1);
        }
        this.omfactory = OMAbstractFactory.getOMFactory();
    }

    public void setOMBuilderFactory(OMFactory ombuilderFactory) {
        this.omfactory = ombuilderFactory;
    }

    protected abstract void processNamespaceData(OMElement var1);

    protected void processAttributes(OMElement node) {
        int attribCount = this.parser.getAttributeCount();
        for (int i = 0; i < attribCount; ++i) {
            String uri = this.parser.getAttributeNamespace(i);
            String prefix = this.parser.getAttributePrefix(i);
            OMNamespace namespace = null;
            if (uri != null && uri.length() > 0 && (namespace = node.findNamespace(uri, prefix)) == null) {
                if (prefix == null || "".equals(prefix)) {
                    prefix = OMSerializerUtil.getNextNSPrefix();
                }
                namespace = node.declareNamespace(uri, prefix);
            }
            OMAttribute attr = node.addAttribute(this.parser.getAttributeLocalName(i), this.parser.getAttributeValue(i), namespace);
            attr.setAttributeType(this.parser.getAttributeType(i));
        }
    }

    protected OMNode createOMText(int textType) throws OMException {
        if (this.lastNode == null) {
            return null;
        }
        OMNode node = !this.lastNode.isComplete() ? this.createOMText((OMElement)this.lastNode, textType) : this.createOMText(this.lastNode.getParent(), textType);
        return node;
    }

    private OMNode createOMText(OMContainer omContainer, int textType) {
        String text;
        if (this.dataHandlerReader != null && this.dataHandlerReader.isBinary()) {
            DataHandlerProvider dataHandlerObject;
            if (this.dataHandlerReader.isDeferred()) {
                dataHandlerObject = this.dataHandlerReader.getDataHandlerProvider();
            } else {
                try {
                    dataHandlerObject = this.dataHandlerReader.getDataHandler();
                }
                catch (XMLStreamException ex) {
                    throw new OMException(ex);
                }
            }
            OMText text2 = this.omfactory.createOMText(dataHandlerObject, this.dataHandlerReader.isOptimized());
            String contentID = this.dataHandlerReader.getContentID();
            if (contentID != null) {
                text2.setContentID(contentID);
            }
            omContainer.addChild(text2);
            return text2;
        }
        try {
            text = this.parser.getText();
        }
        catch (RuntimeException ex) {
            this.parserException = ex;
            throw ex;
        }
        return this.omfactory.createOMText(omContainer, text, textType);
    }

    public void reset(OMNode node) throws OMException {
        this.lastNode = null;
    }

    public void discard(OMElement element) throws OMException {
        if (element.isComplete() || !this.cache) {
            throw new OMException();
        }
        try {
            int event = 0;
            XMLStreamReader elementParser = element.getXMLStreamReaderWithoutCaching();
            while ((event = elementParser.next()) != 2 || !element.getLocalName().equals(elementParser.getLocalName())) {
            }
            this.lastNode = element.getPreviousOMSibling();
            this.cache = true;
            this.parserAccessed = false;
            if (this.lastNode != null) {
                OMContainerEx ex = (OMContainerEx)this.lastNode.getParent();
                ex.setLastChild(this.lastNode);
                if (!(this.lastNode instanceof OMContainerEx)) {
                    ex.buildNext();
                } else {
                    ((OMNodeEx)this.lastNode).setNextOMSibling(null);
                }
            } else {
                OMElement parent = (OMElement)element.getParent();
                if (parent == null) {
                    throw new OMException();
                }
                ((OMContainerEx)((Object)parent)).setFirstChild(null);
                this.lastNode = parent;
            }
        }
        catch (OMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OMException(e);
        }
        --this.elementLevel;
    }

    public String getText() throws OMException {
        return this.parser.getText();
    }

    public String getNamespace() throws OMException {
        return this.parser.getNamespaceURI();
    }

    public int getNamespaceCount() throws OMException {
        try {
            return this.parser.getNamespaceCount();
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    public String getNamespacePrefix(int index) throws OMException {
        try {
            return this.parser.getNamespacePrefix(index);
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    public String getNamespaceUri(int index) throws OMException {
        try {
            return this.parser.getNamespaceURI(index);
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    public void setCache(boolean b) {
        if (this.parserAccessed && b) {
            throw new UnsupportedOperationException("parser accessed. cannot set cache");
        }
        this.cache = b;
    }

    public boolean isCache() {
        return this.cache;
    }

    public String getName() throws OMException {
        return this.parser.getLocalName();
    }

    public String getPrefix() throws OMException {
        return this.parser.getPrefix();
    }

    public int getAttributeCount() throws OMException {
        return this.parser.getAttributeCount();
    }

    public String getAttributeNamespace(int arg) throws OMException {
        return this.parser.getAttributeNamespace(arg);
    }

    public String getAttributeName(int arg) throws OMException {
        return this.parser.getAttributeNamespace(arg);
    }

    public String getAttributePrefix(int arg) throws OMException {
        return this.parser.getAttributeNamespace(arg);
    }

    public Object getParser() {
        if (this.parserAccessed) {
            throw new IllegalStateException("Parser already accessed!");
        }
        if (!this.cache) {
            this.parserAccessed = true;
            return this.parser;
        }
        throw new IllegalStateException("cache must be switched off to access the parser");
    }

    public boolean isCompleted() {
        return this.done;
    }

    protected abstract OMNode createOMElement() throws OMException;

    public abstract int next() throws OMException;

    public CustomBuilder registerCustomBuilder(QName qName, int maxDepth, CustomBuilder customBuilder) {
        CustomBuilder old = null;
        if (this.customBuilders == null) {
            this.customBuilders = new HashMap();
        } else {
            old = (CustomBuilder)this.customBuilders.get(qName);
        }
        this.maxDepthForCustomBuilders = this.maxDepthForCustomBuilders > maxDepth ? this.maxDepthForCustomBuilders : maxDepth;
        this.customBuilders.put(qName, customBuilder);
        return old;
    }

    public CustomBuilder registerCustomBuilderForPayload(CustomBuilder customBuilder) {
        CustomBuilder old = null;
        this.customBuilderForPayload = customBuilder;
        return old;
    }

    protected CustomBuilder getCustomBuilder(String namespace, String localPart) {
        if (this.customBuilders == null) {
            return null;
        }
        QName qName = new QName(namespace, localPart);
        return (CustomBuilder)this.customBuilders.get(qName);
    }

    public short getBuilderType() {
        return 1;
    }

    public void registerExternalContentHandler(Object obj) {
        throw new UnsupportedOperationException();
    }

    public Object getRegisteredContentHandler() {
        throw new UnsupportedOperationException();
    }

    public OMDocument getDocument() {
        return this.document;
    }

    public String getCharsetEncoding() {
        return this.document.getCharsetEncoding();
    }

    public OMNode getLastNode() {
        return this.lastNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (!this.isClosed()) {
                this.parser.close();
            }
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception occurred during parser close.  Processing continues. " + e));
            }
        }
        finally {
            this._isClosed = true;
            this.done = true;
            if (this._releaseParserOnClose) {
                this.parser = null;
            }
        }
    }

    public Object getReaderProperty(String name) throws IllegalArgumentException {
        if (!this.isClosed()) {
            return this.parser.getProperty(name);
        }
        return null;
    }

    public String getCharacterEncoding() {
        if (this.charEncoding == null) {
            return "UTF-8";
        }
        return this.charEncoding;
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void releaseParserOnClose(boolean value) {
        if (this.isClosed() && value) {
            this.parser = null;
        }
        this._releaseParserOnClose = value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

