/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.dialect;

import javax.xml.stream.XMLStreamException;

final class Scanner {
    private final String s;
    private int pos;

    Scanner(String s) {
        this.s = s;
    }

    int peek() {
        return this.pos == this.s.length() ? -1 : (int)this.s.charAt(this.pos);
    }

    String getName() {
        char c;
        int start = this.pos;
        while (this.pos < this.s.length() && ('a' <= (c = this.s.charAt(this.pos)) && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == ':' || c == '_' || c == '-' || c == '.' || c > '\u0080')) {
            ++this.pos;
        }
        return this.pos == start ? null : this.s.substring(start, this.pos);
    }

    String getQuotedString() throws XMLStreamException {
        int quoteChar = this.peek();
        if (quoteChar == 39 || quoteChar == 34) {
            ++this.pos;
            int start = this.pos;
            while (this.pos < this.s.length() && this.s.charAt(this.pos) != quoteChar) {
                ++this.pos;
            }
            if (this.peek() == quoteChar) {
                return this.s.substring(start, this.pos++);
            }
            throw new XMLStreamException("Untermined quoted string");
        }
        throw new XMLStreamException("Expected quote char at position " + this.pos);
    }

    void expect(String seq) throws XMLStreamException {
        boolean found;
        if (this.pos + seq.length() > this.s.length()) {
            found = false;
        } else {
            found = true;
            for (int i = 0; i < seq.length(); ++i) {
                if (this.s.charAt(this.pos + i) == seq.charAt(i)) continue;
                found = false;
                break;
            }
        }
        if (found) {
            this.pos += seq.length();
        } else {
            throw new XMLStreamException("Expected \"" + seq + "\" at position " + this.pos);
        }
    }

    void skipSpace() {
        char c;
        while (this.pos < this.s.length() && ((c = this.s.charAt(this.pos)) == ' ' || c == '\t' || c == '\r' || c == '\n')) {
            ++this.pos;
        }
    }
}

