/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.mtom;

import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.MTOMConstants;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;

public class MTOMStAXSOAPModelBuilder
extends StAXSOAPModelBuilder
implements MTOMConstants {
    Attachments attachments;
    int partIndex = 0;

    public MTOMStAXSOAPModelBuilder(XMLStreamReader parser, SOAPFactory factory, Attachments attachments, String soapVersion) {
        super(parser, factory, soapVersion);
        this.attachments = attachments;
    }

    public MTOMStAXSOAPModelBuilder(XMLStreamReader reader, Attachments attachments, String soapVersion) {
        super(reader, soapVersion);
        this.attachments = attachments;
    }

    protected OMNode createOMElement() throws OMException {
        OMElement node;
        ++this.elementLevel;
        String elementName = this.parser.getLocalName();
        String namespaceURI = this.parser.getNamespaceURI();
        if ("Include".equalsIgnoreCase(elementName) && "http://www.w3.org/2004/08/xop/include".equalsIgnoreCase(namespaceURI)) {
            OMText node2;
            if (this.lastNode == null) {
                throw new OMException("XOP:Include element is not supported here");
            }
            String contentID = ElementHelper.getContentID(this.parser, this.getDocument().getCharsetEncoding());
            try {
                OMElement e = (OMElement)this.lastNode;
                node2 = this.omfactory.createOMText(contentID, (OMElement)this.lastNode, this);
                e.setFirstChild(node2);
            }
            catch (ClassCastException e) {
                throw new OMException("Last Node & Parent of an OMText should be an Element" + e);
            }
            return node2;
        }
        if (this.lastNode == null) {
            node = this.constructNode(null, elementName, true);
            this.setSOAPEnvelope(node);
        } else if (this.lastNode.isComplete()) {
            node = this.constructNode((OMElement)this.lastNode.getParent(), elementName, false);
            ((OMNodeEx)this.lastNode).setNextOMSibling(node);
            ((OMNodeEx)((Object)node)).setPreviousOMSibling(this.lastNode);
        } else {
            OMElement e = (OMElement)this.lastNode;
            node = this.constructNode((OMElement)this.lastNode, elementName, false);
            e.setFirstChild(node);
        }
        this.processAttributes(node);
        return node;
    }

    public DataHandler getDataHandler(String blobContentID) throws OMException {
        return this.attachments.getDataHandler(blobContentID);
    }
}

