/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetadata {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMetadata.class);
    private List<String> paths = new ArrayList<String>();
    private Set<MediaType> consumes = new LinkedHashSet<MediaType>();
    private Set<MediaType> produces = new LinkedHashSet<MediaType>();
    private boolean encoded = false;
    private String defaultValue = null;

    public String getPath() {
        logger.trace("getPath() entry");
        if (this.paths.size() == 0) {
            logger.trace("getPath() exit returning null");
            return null;
        }
        String p = this.paths.get(0);
        logger.trace("getPath() exit returning {}", (Object)p);
        return p;
    }

    public void addPath(String path) {
        logger.trace("addPath({}) entry", (Object)path);
        this.paths.add(path);
        logger.trace("addPath() exit");
    }

    public void addPaths(Collection<String> paths) {
        logger.trace("addPath({}) entry", paths);
        this.paths.addAll(paths);
        logger.trace("addPath() exit", paths);
    }

    public void addConsumes(MediaType mt) {
        logger.trace("addConsumes({}) entry", (Object)mt);
        this.consumes.add(mt);
        logger.trace("addConsumes() exit");
    }

    public void addProduces(MediaType mt) {
        logger.trace("addProduces({}) entry", (Object)mt);
        this.produces.add(mt);
        logger.trace("addProduces() exit");
    }

    public List<String> getPaths() {
        return Collections.unmodifiableList(this.paths);
    }

    public Set<MediaType> getConsumes() {
        return Collections.unmodifiableSet(this.consumes);
    }

    public Set<MediaType> getProduces() {
        return Collections.unmodifiableSet(this.produces);
    }

    public String toString() {
        return "[" + (this.consumes != null ? "consumes=" + this.consumes + ", " : "") + (this.paths != null ? "paths=" + this.paths + ", " : "") + (this.produces != null ? "produces=" + this.produces : "") + "]";
    }

    public void setEncoded(boolean encoded) {
        logger.trace("setEncoded({}) entry", (Object)encoded);
        this.encoded = encoded;
        logger.trace("setEncoded({}) exit", (Object)encoded);
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        logger.trace("setDefaultValue({}) entry", (Object)defaultValue);
        this.defaultValue = defaultValue;
        logger.trace("setDefaultValue() exit");
    }
}

