/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *  
 *   http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *  
 *******************************************************************************/
//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, vhudson-jaxb-ri-2.1-456 
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a> 
// Any modifications to this file will be lost upon recompilation of the source schema. 
// Generated on: 2009.07.20 at 10:55:05 AM IST 
//
package org.apache.wink.common.model.rss;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.model.synd.SyndCategory;
import org.apache.wink.common.model.synd.SyndEntry;
import org.apache.wink.common.model.synd.SyndFeed;
import org.apache.wink.common.model.synd.SyndGenerator;
import org.apache.wink.common.model.synd.SyndLink;
import org.apache.wink.common.model.synd.SyndPerson;
import org.apache.wink.common.model.synd.SyndText;
import org.apache.wink.common.model.synd.SyndTextType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <p>
 * Java class for "channel" element of <a
 * href="http://www.rssboard.org/rss-specification">RSS 2.0 Specification</a>.
 * <p>
 * The following schema fragment specifies the expected content contained within
 * this class.
 * 
 * <pre>
 * &lt;complexType name=&quot;rssChannel&quot;&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base=&quot;{http://www.w3.org/2001/XMLSchema}anyType&quot;&gt;
 *       &lt;sequence&gt;
 *         &lt;element name=&quot;title&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot;/&gt;
 *         &lt;element name=&quot;link&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}anyURI&quot;/&gt;
 *         &lt;element name=&quot;description&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot;/&gt;
 *         &lt;element name=&quot;language&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;copyright&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;managingEditor&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;webMaster&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;pubDate&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;lastBuildDate&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;category&quot; type=&quot;{}rssCategory&quot; maxOccurs=&quot;unbounded&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;generator&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;docs&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}anyURI&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;cloud&quot; type=&quot;{}rssCloud&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;ttl&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}int&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;image&quot; type=&quot;{}rssImage&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;rating&quot; type=&quot;{http://www.w3.org/2001/XMLSchema}string&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;textInput&quot; type=&quot;{}rssTextInput&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;skipHours&quot; type=&quot;{}rssSkipHours&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;element name=&quot;skipDays&quot; type=&quot;{}rssSkipDays&quot; minOccurs=&quot;0&quot;/&gt;
 *         &lt;any/&gt;
 *         &lt;element name=&quot;item&quot; type=&quot;{}rssItem&quot; maxOccurs=&quot;unbounded&quot; minOccurs=&quot;0&quot;/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * <h4>Required channel elements</h4>
 * <p>
 * Here's a list of the required channel elements, each with a brief
 * description, an example, and where available, a pointer to a more complete
 * description.
 * </p>
 * <table cellspacing="10">
 * <tbody>
 * <tr valign="top">
 * <td><i>Element</i></td>
 * <td width="65%"><i>Description</i></td>
 * <td><i>Example</i></td>
 * </tr>
 * <tr valign="top">
 * <td><span>title</span></td>
 * <td>The name of the channel. It's how people refer to your service. If you
 * have an HTML website that contains the same information as your RSS file, the
 * title of your channel should be the same as the title of your website.</td>
 * <td>GoUpstate.com News Headlines</td>
 * </tr>
 * <tr valign="top">
 * <td><span>link</span></td>
 * <td>The URL to the HTML website corresponding to the channel.</td>
 * <td>http://www.goupstate.com/</td>
 * </tr>
 * <tr valign="top">
 * <td><span>description</span></td>
 * <td>Phrase or sentence describing the channel.</td>
 * <td>The latest news from GoUpstate.com, a Spartanburg Herald-Journal Web
 * site.</td>
 * </tr>
 * </tbody>
 * </table>
 * <h4>Optional channel elements</h4>
 * <p>
 * Here's a list of optional channel elements.
 * </p>
 * <table cellspacing="10">
 * <tbody>
 * <tr valign="top">
 * <td><i>Element</i></td>
 * <td width="65%"><i>Description</i></td>
 * <td><i>Example</i></td>
 * </tr>
 * <tr valign="top">
 * <td><span>language</span></td>
 * <td>The language the channel is written in. This allows aggregators to group
 * all Italian language sites, for example, on a single page. A list of
 * allowable values for this element, as provided by Netscape, is <a
 * href="http://www.rssboard.org/rss-language-codes">here</a>. You may also use
 * <a
 * href="http://www.w3.org/TR/REC-html40/struct/dirlang.html#langcodes">values
 * defined</a> by the W3C.</td>
 * <td>en-us</td>
 * </tr>
 * <tr valign="top">
 * <td><span>copyright</span></td>
 * <td>Copyright notice for content in the channel.</td>
 * <td>Copyright 2002, Spartanburg Herald-Journal</td>
 * </tr>
 * <tr valign="top">
 * <td><span>managingEditor</span></td>
 * <td>Email address for person responsible for editorial content.</td>
 * <td>geo@herald.com (George Matesky)</td>
 * </tr>
 * <tr valign="top">
 * <td><span>webMaster</span></td>
 * <td>Email address for person responsible for technical issues relating to
 * channel.</td>
 * <td>betty@herald.com (Betty Guernsey)</td>
 * </tr>
 * <tr valign="top">
 * <td><span>pubDate</span></td>
 * <td>The publication date for the content in the channel. For example, the
 * <i>New York Times</i> publishes on a daily basis, the publication date flips
 * once every 24 hours. That's when the pubDate of the channel changes. All
 * date-times in RSS conform to the Date and Time Specification of <a
 * href="http://asg.web.cmu.edu/rfc/rfc822.html">RFC 822</a>, with the exception
 * that the year may be expressed with two characters or four characters (four
 * preferred).</td>
 * <td>Sat, 07 Sep 2002 00:00:01 GMT</td>
 * </tr>
 * <tr valign="top">
 * <td><span>lastBuildDate</span></td>
 * <td>The last time the content of the channel changed.</td>
 * <td>Sat, 07 Sep 2002 09:42:31 GMT</td>
 * </tr>
 * <tr valign="top">
 * <td><span>category</span></td>
 * <td>Specify one or more categories that the channel belongs to. Follows the
 * same rules as the &lt;item&gt;-level {@linkplain RssCategory category}
 * element.</td>
 * <td>&lt;category&gt;Newspapers&lt;/category&gt;</td>
 * </tr>
 * <tr valign="top">
 * <td><span>generator</span></td>
 * <td>A string indicating the program used to generate the channel.</td>
 * <td>MightyInHouse Content System v2.3</td>
 * </tr>
 * <tr valign="top">
 * <td><span>docs</span></td>
 * <td>A URL that points to the <a
 * href="http://www.rssboard.org/rss-specification">documentation</a> for the
 * format used in the RSS file. It's probably a pointer to this page. It's for
 * people who might stumble across an RSS file on a Web server 25 years from now
 * and wonder what it is.</td>
 * <td>http://www.rssboard.org/rss-specification</td>
 * </tr>
 * <tr valign="top">
 * <td><span>cloud</span></td>
 * <td>Allows processes to register with a cloud to be notified of updates to
 * the channel, implementing a lightweight publish-subscribe protocol for RSS
 * feeds. More info {@linkplain RssCloud here}.</td>
 * <td>&lt;cloud domain="rpc.sys.com" port="80" path="/RPC2"
 * registerProcedure="pingMe" protocol="soap"/&gt;</td>
 * </tr>
 * <tr valign="top">
 * <td><span>ttl</span></td>
 * <td>ttl stands for time to live. It's a number of minutes that indicates how
 * long a channel can be cached before refreshing from the source. This makes it
 * possible for RSS sources to be managed by a file-sharing network such as
 * Gnutella.</td>
 * <td>&lt;ttl&gt;60&lt;/ttl&gt;</td>
 * </tr>
 * <tr valign="top">
 * <td><span>image</span></td>
 * <td>Specifies a GIF, JPEG or PNG image that can be displayed with the
 * channel. More info {@linkplain RssImage here}.</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td><span>rating</span></td>
 * <td>The <a href="http://www.w3.org/PICS/">PICS</a> rating for the channel.</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td><span>textInput</span></td>
 * <td>Specifies a text input box that can be displayed with the channel. More
 * info {@linkplain RssTextInput here}.</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td><span>skipHours</span></td>
 * <td>A hint for aggregators telling them which hours they can skip. More info
 * {@linkplain RssSkipHours here}.</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td><span>skipDays</span></td>
 * <td>A hint for aggregators telling them which days they can skip. More info
 * {@linkplain RssSkipDays here}.</td>
 * <td></td>
 * </tr>
 * </tbody>
 * </table>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "rssChannel", propOrder = {})
public class RssChannel {

    @XmlElement(required = true)
    protected String            title;
    @XmlElement(required = true)
    @XmlSchemaType(name = "anyURI")
    protected String            link;
    @XmlElement(required = true)
    protected String            description;
    protected String            language;
    protected String            copyright;
    protected String            managingEditor;
    protected String            webMaster;
    protected String            pubDate;
    protected String            lastBuildDate;
    protected List<RssCategory> category;
    protected String            generator;
    @XmlSchemaType(name = "anyURI")
    protected String            docs;
    protected RssCloud          cloud;
    protected Integer           ttl;
    protected RssImage          image;
    protected String            rating;
    protected RssTextInput      textInput;
    protected RssSkipHours      skipHours;
    protected RssSkipDays       skipDays;
    @XmlAnyElement(lax = true)
    protected List<Object>      any;
    protected List<RssItem>     item;

    private static String       RSS_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss z"; //$NON-NLS-1$
    private static final Logger logger          = LoggerFactory.getLogger(RssChannel.class);

    /**
     * Creates an RssChannel object.
     */
    public RssChannel() {
    }

    /**
     * Creates an RssChannel object out of a SyndFeed object. Used for mapping
     * Syndication Object Model into RSS.
     * 
     * @param syndFeed the SyndFeed object which has to be mapped into an
     *            RssChannel object
     */
    public RssChannel(SyndFeed syndFeed) {
        if (syndFeed == null) {
            return;
        }
        if (syndFeed.getTitle() != null && syndFeed.getTitle().getValue() != null) {
            setTitle(syndFeed.getTitle().getValue());
        }
        SyndLink link = syndFeed.getLink("alternate"); //$NON-NLS-1$
        if (link != null && link.getHref() != null) {
            setLink(link.getHref());
        }
        if (syndFeed.getSubtitle() != null && syndFeed.getSubtitle().getValue() != null) {
            setDescription(syndFeed.getSubtitle().getValue());
        }
        if (syndFeed.getLang() != null) {
            setLanguage(syndFeed.getLang());
        }
        if (syndFeed.getRights() != null && syndFeed.getRights().getValue() != null) {
            setCopyright(syndFeed.getRights().getValue());
        }
        if (syndFeed.getAuthors().size() > 0) {
            SyndPerson author = syndFeed.getAuthors().get(0);
            if (author.getEmail() != null) {
                setManagingEditor(author.getEmail());
            }
        }
        if (syndFeed.getUpdated() != null) {
            setLastBuildDate(convertJavaDateToRssDate(syndFeed.getUpdated()));
        }
        getCategories().clear();
        for (SyndCategory syndCategory : syndFeed.getCategories()) {
            getCategories().add(new RssCategory(syndCategory));
        }
        if (syndFeed.getGenerator() != null && syndFeed.getGenerator().getValue() != null) {
            setGenerator(syndFeed.getGenerator().getValue());
        }
        if (syndFeed.getLogo() != null) {
            RssImage rssImage = new RssImage();
            rssImage.setUrl(syndFeed.getLogo());
            // http://www.rssboard.org/rss-specification mentions that, in
            // practice the image <title> and <link> should have the same value
            // as the channel's <title> and <link>.
            rssImage.setTitle(getTitle());
            rssImage.setLink(getLink());
            setImage(rssImage);
        }
        getItems().clear();
        for (SyndEntry syndEntry : syndFeed.getEntries()) {
            RssItem rssItem = new RssItem(syndEntry);
            getItems().add(rssItem);
        }
    }

    /**
     * Maps an RssChannel object into a SyndFeed object. Used for mapping RSS
     * into Syndication Object Model.
     * 
     * @param syndFeed the syndFeed object into which the given RssChannel
     *            object has to be mapped into
     * @return the SyndFeed object into which the given RssChannel object has
     *         been mapped into
     */
    public SyndFeed toSynd(SyndFeed syndFeed) {
        if (syndFeed == null) {
            return syndFeed;
        }
        if (getTitle() != null) {
            syndFeed.setTitle(new SyndText(getTitle(), SyndTextType.text));
        }
        if (getLink() != null) {
            SyndLink syndLink = new SyndLink();
            syndLink.setHref(getLink());
            syndLink.setRel("alternate"); //$NON-NLS-1$
            syndFeed.getLinks().add(syndLink);
        }
        if (getDescription() != null) {
            syndFeed.setSubtitle(new SyndText(getDescription(), SyndTextType.text));
        }
        if (getLanguage() != null) {
            syndFeed.setLang(getLanguage());
        }
        if (getCopyright() != null) {
            syndFeed.setRights(new SyndText(getCopyright()));
        }
        if (getManagingEditor() != null) {
            SyndPerson syndAuthor = new SyndPerson();
            String authorEmail = getManagingEditor();
            syndAuthor.setEmail(authorEmail);
            syndAuthor.setName(authorEmail.substring(0, authorEmail.indexOf("@"))); //$NON-NLS-1$
            syndFeed.getAuthors().add(syndAuthor);
        }
        if (getLastBuildDate() != null) {
            syndFeed.setUpdated(convertRssDateToJavaDate(getLastBuildDate()));
        }
        syndFeed.getCategories().clear();
        for (RssCategory rssCategory : getCategories()) {
            SyndCategory syndCategory = new SyndCategory();
            syndCategory = rssCategory.toSynd(syndCategory);
            syndFeed.getCategories().add(syndCategory);
        }
        if (getGenerator() != null) {
            syndFeed.setGenerator(new SyndGenerator(getGenerator()));
        }
        if (getImage() != null && getImage().getUrl() != null) {
            syndFeed.setLogo(getImage().getUrl());
        }
        syndFeed.getEntries().clear();
        for (RssItem rssItem : getItems()) {
            SyndEntry syndEntry = new SyndEntry();
            syndEntry = rssItem.toSynd(syndEntry);
            syndFeed.getEntries().add(syndEntry);
        }
        return syndFeed;
    }

    /**
     * Gets the value of the title property.
     * 
     * @return possible object is {@link String }
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setTitle(String value) {
        this.title = value;
    }

    /**
     * Gets the value of the link property.
     * 
     * @return possible object is {@link String }
     */
    public String getLink() {
        return link;
    }

    /**
     * Sets the value of the link property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setLink(String value) {
        this.link = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return possible object is {@link String }
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the language property.
     * 
     * @return possible object is {@link String }
     */
    public String getLanguage() {
        return language;
    }

    /**
     * Sets the value of the language property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setLanguage(String value) {
        this.language = value;
    }

    /**
     * Gets the value of the copyright property.
     * 
     * @return possible object is {@link String }
     */
    public String getCopyright() {
        return copyright;
    }

    /**
     * Sets the value of the copyright property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setCopyright(String value) {
        this.copyright = value;
    }

    /**
     * Gets the value of the managingEditor property.
     * 
     * @return possible object is {@link String }
     */
    public String getManagingEditor() {
        return managingEditor;
    }

    /**
     * Sets the value of the managingEditor property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setManagingEditor(String value) {
        this.managingEditor = value;
    }

    /**
     * Gets the value of the webMaster property.
     * 
     * @return possible object is {@link String }
     */
    public String getWebMaster() {
        return webMaster;
    }

    /**
     * Sets the value of the webMaster property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setWebMaster(String value) {
        this.webMaster = value;
    }

    /**
     * Gets the value of the pubDate property.
     * 
     * @return possible object is {@link String }
     */
    public String getPubDate() {
        return pubDate;
    }

    /**
     * Sets the value of the pubDate property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setPubDate(String value) {
        this.pubDate = value;
    }

    /**
     * Gets the value of the lastBuildDate property.
     * 
     * @return possible object is {@link String }
     */
    public String getLastBuildDate() {
        return lastBuildDate;
    }

    /**
     * Sets the value of the lastBuildDate property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setLastBuildDate(String value) {
        this.lastBuildDate = value;
    }

    /**
     * Gets the value of the category property.
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the category property.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getCategory().add(newItem);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RssCategory }
     */
    public List<RssCategory> getCategories() {
        if (category == null) {
            category = new ArrayList<RssCategory>();
        }
        return this.category;
    }

    /**
     * Gets the value of the generator property.
     * 
     * @return possible object is {@link String }
     */
    public String getGenerator() {
        return generator;
    }

    /**
     * Sets the value of the generator property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setGenerator(String value) {
        this.generator = value;
    }

    /**
     * Gets the value of the docs property.
     * 
     * @return possible object is {@link String }
     */
    public String getDocs() {
        return docs;
    }

    /**
     * Sets the value of the docs property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setDocs(String value) {
        this.docs = value;
    }

    /**
     * Gets the value of the cloud property.
     * 
     * @return possible object is {@link RssCloud }
     */
    public RssCloud getCloud() {
        return cloud;
    }

    /**
     * Sets the value of the cloud property.
     * 
     * @param value allowed object is {@link RssCloud }
     */
    public void setCloud(RssCloud value) {
        this.cloud = value;
    }

    /**
     * Gets the value of the ttl property.
     * 
     * @return possible object is {@link Integer }
     */
    public Integer getTtl() {
        return ttl;
    }

    /**
     * Sets the value of the ttl property.
     * 
     * @param value allowed object is {@link Integer }
     */
    public void setTtl(Integer value) {
        this.ttl = value;
    }

    /**
     * Gets the value of the image property.
     * 
     * @return possible object is {@link RssImage }
     */
    public RssImage getImage() {
        return image;
    }

    /**
     * Sets the value of the image property.
     * 
     * @param value allowed object is {@link RssImage }
     */
    public void setImage(RssImage value) {
        this.image = value;
    }

    /**
     * Gets the value of the rating property.
     * 
     * @return possible object is {@link String }
     */
    public String getRating() {
        return rating;
    }

    /**
     * Sets the value of the rating property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setRating(String value) {
        this.rating = value;
    }

    /**
     * Gets the value of the textInput property.
     * 
     * @return possible object is {@link RssTextInput }
     */
    public RssTextInput getTextInput() {
        return textInput;
    }

    /**
     * Sets the value of the textInput property.
     * 
     * @param value allowed object is {@link RssTextInput }
     */
    public void setTextInput(RssTextInput value) {
        this.textInput = value;
    }

    /**
     * Gets the value of the skipHours property.
     * 
     * @return possible object is {@link RssSkipHours }
     */
    public RssSkipHours getSkipHours() {
        return skipHours;
    }

    /**
     * Sets the value of the skipHours property.
     * 
     * @param value allowed object is {@link RssSkipHours }
     */
    public void setSkipHours(RssSkipHours value) {
        this.skipHours = value;
    }

    /**
     * Gets the value of the skipDays property.
     * 
     * @return possible object is {@link RssSkipDays }
     */
    public RssSkipDays getSkipDays() {
        return skipDays;
    }

    /**
     * Sets the value of the skipDays property.
     * 
     * @param value allowed object is {@link RssSkipDays }
     */
    public void setSkipDays(RssSkipDays value) {
        this.skipDays = value;
    }

    /**
     * Gets the value of the any property.
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the any property.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getAny().add(newItem);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list {@link Object }
     */
    public List<Object> getAny() {
        if (any == null) {
            any = new ArrayList<Object>();
        }
        return this.any;
    }

    /**
     * Gets the value of the item property.
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the item property.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getItem().add(newItem);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list {@link RssItem }
     */
    public List<RssItem> getItems() {
        if (item == null) {
            item = new ArrayList<RssItem>();
        }
        return this.item;
    }

    public static String convertJavaDateToRssDate(Date javaDate) {
        SimpleDateFormat format = new SimpleDateFormat(RSS_DATE_FORMAT);
        return format.format(javaDate);
    }

    public static Date convertRssDateToJavaDate(String rssDate) {
        SimpleDateFormat format = new SimpleDateFormat(RSS_DATE_FORMAT);
        try {
            return format.parse(rssDate);
        } catch (ParseException e) {
            logger.error(Messages.getMessage("listExceptionDuringClassProcessing"), e); //$NON-NLS-1$
        }
        return null;
    }
}
