/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *  
 *   http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *  
 *******************************************************************************/
//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.1.1-b02-fcs 
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a> 
// Any modifications to this file will be lost upon recompilation of the source schema. 
// Generated on: 2008.09.15 at 09:38:06 AM IDT 
//

package org.apache.wink.common.model.app;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.apache.wink.common.RestException;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.model.ModelUtils;
import org.apache.wink.common.internal.utils.JAXBUtils;
import org.apache.wink.common.model.atom.AtomCategory;

/**
 * The "app:categories" Element Per RFC5023
 * 
 * <pre>
 * The &quot;app:categories&quot; Element
 * 
 *    The root of a Category Document is the &quot;app:categories&quot; element.  An
 *    app:categories element can contain zero or more atom:category
 *    elements from the Atom Syndication Format [RFC4287] namespace
 *    (&quot;http://www.w3.org/2005/Atom&quot;).
 * 
 *    An atom:category child element that has no &quot;scheme&quot; attribute
 *    inherits the attribute from its app:categories parent.  An atom:
 *    category child element with an existing &quot;scheme&quot; attribute does not
 *    inherit the &quot;scheme&quot; value of its app:categories parent element.
 * 
 *    atomCategory =
 *        element atom:category {
 *           atomCommonAttributes,
 *           attribute term { text },
 *           attribute scheme { atomURI }?,
 *           attribute label { text }?,
 *           undefinedContent
 *        }
 * 
 *    appInlineCategories =
 *        element app:categories {
 *            attribute fixed { &quot;yes&quot; | &quot;no&quot; }?,
 *            attribute scheme { atomURI }?,
 *            (atomCategory*,
 *            undefinedContent)
 *        }
 * 
 *    appOutOfLineCategories =
 *        element app:categories {
 *            attribute href { atomURI },
 *            undefinedContent
 *        }
 * 
 *    appCategories = appInlineCategories | appOutOfLineCategories
 * 
 * o Attributes of &quot;app:categories&quot;
 * 
 *    The app:categories element can contain a &quot;fixed&quot; attribute, with a
 *    value of either &quot;yes&quot; or &quot;no&quot;, indicating whether the list of
 *    categories is a fixed or an open set.  The absence of the &quot;fixed&quot;
 *    attribute is equivalent to the presence of a &quot;fixed&quot; attribute with a
 *    value of &quot;no&quot;.
 * 
 *    Alternatively, the app:categories element MAY contain an &quot;href&quot;
 *    attribute, whose value MUST be an IRI reference identifying a
 *    Category Document.  If the &quot;href&quot; attribute is provided, the app:
 *    categories element MUST be empty and MUST NOT have the &quot;fixed&quot; or
 *    &quot;scheme&quot; attributes.
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "appCategories", propOrder = {"category"})
public class AppCategories {

    @XmlElement(namespace = "http://www.w3.org/2005/Atom")
    protected List<AtomCategory>     category;
    @XmlAttribute
    protected AppYesNo               fixed;
    @XmlAttribute
    protected String                 scheme;
    @XmlAttribute
    protected String                 href;

    @XmlTransient
    boolean                          isFixedSet    = false;

    private static final String      ERROR_MESSAGE =
                                                       Messages.getMessage("cannotMixInlineAndOutOfLine"); //$NON-NLS-1$

    // ============================
    @XmlTransient
    private static final JAXBContext context;

    static {
        try {
            context = JAXBContext.newInstance(AppCategories.class.getPackage().getName());
        } catch (JAXBException e) {
            throw new RestException(Messages.getMessage("failedToCreateJAXBContextFor", "AppCategories"), e); //$NON-NLS-1$ //$NON-NLS-2$
        }
    }

    public static Marshaller getMarshaller() {
        return JAXBUtils.createMarshaller(context);
    }

    public static Unmarshaller getUnmarshaller() {
        return JAXBUtils.createUnmarshaller(context);
    }

    /**
     * Convenience method for creating an AppCategories from xml
     * 
     * @param reader input reader
     * @return AppCategories instance from the input
     */
    public static AppCategories unmarshal(Reader reader) {
        try {
            return (AppCategories)ModelUtils.unmarshal(AppCategories.getUnmarshaller(), reader);
        } catch (IOException e) {
            throw new RestException(e);
        }
    }

    // ============================

    /**
     * Gets the value of the category property.
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the category property.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getCategory().add(newItem);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AtomCategory }
     */
    public List<AtomCategory> getCategory() {
        if (!isInline()) {
            throw new RestException(ERROR_MESSAGE);
        }
        return getCategoryNoCheck();
    }

    private List<AtomCategory> getCategoryNoCheck() {
        if (category == null) {
            category = new ArrayList<AtomCategory>();
        }
        return this.category;
    }

    /**
     * Gets the value of the fixed property.
     * 
     * @return possible object is {@link AppYesNo }
     */
    public AppYesNo getFixed() {
        if (fixed == null) {
            return AppYesNo.NO;
        } else {
            return fixed;
        }
    }

    /**
     * Sets the value of the fixed property.
     * 
     * @param value allowed object is {@link AppYesNo }
     */
    public void setFixed(AppYesNo value) {
        isFixedSet = true;
        this.fixed = value;
        checkValidity();
    }

    public boolean isFixedSet() {
        return isFixedSet;
    }

    /**
     * Gets the value of the scheme property.
     * 
     * @return possible object is {@link String }
     */
    public String getScheme() {
        return scheme;
    }

    /**
     * Sets the value of the scheme property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setScheme(String value) {
        this.scheme = value;
        checkValidity();
    }

    /**
     * Gets the value of the href property.
     * 
     * @return possible object is {@link String }
     */
    public String getHref() {
        return href;
    }

    /**
     * Sets the value of the href property.
     * 
     * @param value allowed object is {@link String }
     */
    public void setHref(String value) {
        this.href = value;
        checkValidity();
    }

    public boolean isInline() {
        return getHref() == null;
    }

    public void checkValidity() {
        if ((getScheme() != null || getCategoryNoCheck().size() > 0 || isFixedSet()) && getHref() != null) {
            throw new RestException(ERROR_MESSAGE);
        }
    }

}
