/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.header;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.wink.common.internal.http.AcceptLanguage;
import org.apache.wink.common.internal.utils.HeaderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptLanguageHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<AcceptLanguage> {
    public AcceptLanguage fromString(String value) throws IllegalArgumentException {
        LinkedList<Locale> acceptable = new LinkedList<Locale>();
        LinkedList<Locale> banned = new LinkedList<Locale>();
        boolean anyAllowed = value == null;
        List<AcceptLanguage.ValuedLocale> qLocales = this.parseAcceptLanguage(value);
        for (AcceptLanguage.ValuedLocale qLocale : qLocales) {
            if (anyAllowed) {
                if (qLocale.qValue != 0.0 || qLocale.isWildcard()) continue;
                banned.add(qLocale.locale);
                continue;
            }
            if (qLocale.qValue == 0.0) break;
            if (qLocale.isWildcard()) {
                anyAllowed = true;
                continue;
            }
            acceptable.add(qLocale.locale);
        }
        return new AcceptLanguage(value, acceptable, banned, anyAllowed, qLocales);
    }

    private List<AcceptLanguage.ValuedLocale> parseAcceptLanguage(String acceptLanguageValue) {
        LinkedList<AcceptLanguage.ValuedLocale> qLocales = new LinkedList<AcceptLanguage.ValuedLocale>();
        if (acceptLanguageValue == null) {
            return qLocales;
        }
        for (String languageRange : acceptLanguageValue.split(",")) {
            String languageSpec;
            double qValue;
            int semicolonIndex = languageRange.indexOf(59);
            if (semicolonIndex == -1) {
                qValue = 1.0;
                languageSpec = languageRange;
            } else {
                languageSpec = languageRange.substring(0, semicolonIndex);
                int equalsIndex = languageRange.indexOf(61, semicolonIndex + 1);
                String qString = languageRange.substring(equalsIndex != -1 ? equalsIndex + 1 : languageRange.length());
                try {
                    qValue = Double.parseDouble(qString.trim());
                }
                catch (NumberFormatException nfe) {
                    qValue = 1.0;
                }
            }
            languageSpec = languageSpec.trim();
            if (languageSpec.length() == 0) continue;
            if (languageSpec.equals("*")) {
                qLocales.add(new AcceptLanguage.ValuedLocale(qValue, null));
                continue;
            }
            Locale newLocale = HeaderUtils.languageToLocale(languageSpec);
            qLocales.add(new AcceptLanguage.ValuedLocale(qValue, newLocale));
        }
        Collections.sort(qLocales, Collections.reverseOrder());
        return qLocales;
    }

    public String toString(AcceptLanguage value) {
        return value.getAcceptLanguageHeader();
    }
}

