/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.crypt;

import java.lang.ref.WeakReference;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.crypt.ICryptFactory;
import org.apache.wicket.util.crypt.NoCrypt;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassCryptFactory
implements ICryptFactory {
    private static final Logger log = LoggerFactory.getLogger(ClassCryptFactory.class);
    private final WeakReference<Class<?>> cryptClass;
    private final String encryptionKey;

    public ClassCryptFactory(Class<?> cryptClass, String encryptionKey) {
        Args.notNull(cryptClass, "cryptClass");
        if (!ICrypt.class.isAssignableFrom(cryptClass)) {
            throw new IllegalArgumentException("cryptClass must implement ICrypt interface");
        }
        this.cryptClass = new WeakReference(cryptClass);
        this.encryptionKey = encryptionKey;
    }

    @Override
    public ICrypt newCrypt() {
        try {
            ICrypt crypt = (ICrypt)((Class)this.cryptClass.get()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            log.info("using encryption/decryption object {}", (Object)crypt);
            crypt.setKey(this.encryptionKey);
            return crypt;
        }
        catch (Exception e) {
            log.warn("************************** WARNING **************************");
            log.warn("As the instantiation of encryption/decryption class:");
            log.warn("\t" + this.cryptClass);
            log.warn("failed, Wicket will fallback on a dummy implementation");
            log.warn("\t(" + NoCrypt.class.getName() + ")");
            log.warn("This is NOT recommended for production systems.");
            log.warn("Please override method org.apache.wicket.util.crypt.ICryptFactory.newCrypt()");
            log.warn("to provide a custom encryption/decryption implementation.");
            log.warn("The cause of the instantiation failure: ");
            log.warn("\t" + e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug("exception: ", (Throwable)e);
            } else {
                log.warn("Set log level to DEBUG to display the stack trace.");
            }
            log.warn("*************************************************************");
            return new NoCrypt();
        }
    }
}

