/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.wicket.util.convert.converter.AbstractDecimalConverter;
import org.apache.wicket.util.string.Strings;

public class BigDecimalConverter
extends AbstractDecimalConverter<BigDecimal> {
    private static final long serialVersionUID = 1L;

    @Override
    protected Class<BigDecimal> getTargetType() {
        return BigDecimal.class;
    }

    @Override
    public BigDecimal convertToObject(String value, Locale locale) {
        if (Strings.isEmpty(value)) {
            return null;
        }
        Object number = this.parse(value, -1.7976931348623157E308, Double.MAX_VALUE, locale);
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Double) {
            return new BigDecimal(Double.toString(((Number)number).doubleValue()));
        }
        if (number instanceof Long) {
            return new BigDecimal(((Number)number).longValue());
        }
        if (number instanceof Float) {
            return new BigDecimal(((Number)number).floatValue());
        }
        if (number instanceof Integer) {
            return new BigDecimal(((Number)number).intValue());
        }
        return new BigDecimal(value);
    }
}

