/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring.injection.annot;

import java.io.Serializable;
import javax.servlet.ServletContext;
import org.apache.wicket.Application;
import org.apache.wicket.IClusterable;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.injection.ComponentInjector;
import org.apache.wicket.injection.ConfigurableInjector;
import org.apache.wicket.injection.web.InjectorHolder;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.spring.ISpringContextLocator;
import org.apache.wicket.spring.injection.annot.AnnotSpringInjector;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringComponentInjector
extends ComponentInjector {
    private static MetaDataKey CONTEXT_KEY = new MetaDataKey(ApplicationContextHolder.class){
        private static final long serialVersionUID = 1L;
    };

    public SpringComponentInjector(WebApplication webapp) {
        this(webapp, (ApplicationContext)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)webapp.getServletContext()));
    }

    public SpringComponentInjector(WebApplication webapp, ApplicationContext ctx) {
        if (webapp == null) {
            throw new IllegalArgumentException("Argument [[webapp]] cannot be null");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("Argument [[ctx]] cannot be null");
        }
        webapp.setMetaData(CONTEXT_KEY, (Serializable)((Object)new ApplicationContextHolder(ctx)));
        InjectorHolder.setInjector((ConfigurableInjector)new AnnotSpringInjector(new ContextLocator()));
    }

    private static class ContextLocator
    implements ISpringContextLocator {
        private transient ApplicationContext context;
        private static final long serialVersionUID = 1L;

        private ContextLocator() {
        }

        public ApplicationContext getSpringContext() {
            if (this.context == null) {
                this.context = ((ApplicationContextHolder)((Object)Application.get().getMetaData(CONTEXT_KEY))).getContext();
            }
            return this.context;
        }
    }

    private static class ApplicationContextHolder
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final ApplicationContext context;

        public ApplicationContextHolder(ApplicationContext context) {
            this.context = context;
        }

        public ApplicationContext getContext() {
            return this.context;
        }
    }
}

