/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.components.markup.html.form;

import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.checks.ComponentSecurityCheck;
import org.apache.wicket.security.checks.ISecurityCheck;
import org.apache.wicket.security.components.ISecureComponent;
import org.apache.wicket.security.components.SecureComponentHelper;

public class SecureForm
extends Form
implements ISecureComponent {
    private static final long serialVersionUID = 1L;

    public SecureForm(String id) {
        super(id);
        this.setSecurityCheck(new ComponentSecurityCheck((Component)this));
    }

    public SecureForm(String id, IModel model) {
        super(id, model);
        this.setSecurityCheck(new ComponentSecurityCheck((Component)this));
    }

    public ISecurityCheck getSecurityCheck() {
        return SecureComponentHelper.getSecurityCheck((Component)this);
    }

    public boolean isActionAuthorized(String waspAction) {
        return SecureComponentHelper.isActionAuthorized((Component)this, waspAction);
    }

    public boolean isActionAuthorized(WaspAction action) {
        return SecureComponentHelper.isActionAuthorized((Component)this, action);
    }

    public boolean isAuthenticated() {
        return SecureComponentHelper.isAuthenticated((Component)this);
    }

    public void setSecurityCheck(ISecurityCheck check) {
        SecureComponentHelper.setSecurityCheck((Component)this, check);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!this.isEnableAllowed()) {
            tag.setName("div");
            tag.remove("method");
            tag.remove("action");
            tag.remove("enctype");
        }
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        if (!this.isEnableAllowed()) {
            this.visitChildren(new Component.IVisitor(){

                public Object component(Component component) {
                    component.setEnabled(false);
                    return Component.IVisitor.CONTINUE_TRAVERSAL;
                }
            });
        }
    }
}

