/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.components;

import java.io.Serializable;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.security.WaspApplication;
import org.apache.wicket.security.actions.ActionFactory;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.checks.ISecurityCheck;
import org.apache.wicket.security.checks.WaspKey;
import org.apache.wicket.security.components.ISecureComponent;
import org.apache.wicket.security.models.ISecureModel;
import org.apache.wicket.security.strategies.SecurityException;

public final class SecureComponentHelper {
    public static ISecurityCheck getSecurityCheck(Component component) {
        if (component != null) {
            return (ISecurityCheck)component.getMetaData((MetaDataKey)new WaspKey());
        }
        return null;
    }

    public static Component setSecurityCheck(Component component, ISecurityCheck securityCheck) {
        if (component == null) {
            return null;
        }
        component.setMetaData((MetaDataKey)new WaspKey(), (Serializable)securityCheck);
        return component;
    }

    private static ISecurityCheck saveGetSecurityCheck(Component component) {
        if (component instanceof ISecureComponent) {
            return ((ISecureComponent)component).getSecurityCheck();
        }
        return SecureComponentHelper.getSecurityCheck(component);
    }

    public static boolean hasSecureModel(Component component) {
        return component != null && component.getModel() instanceof ISecureModel;
    }

    private static ActionFactory getActionFactory() {
        Application application = Application.get();
        if (application instanceof WaspApplication) {
            WaspApplication app = (WaspApplication)application;
            return app.getActionFactory();
        }
        throw new WicketRuntimeException(application + " is not a WaspApplication");
    }

    public static boolean isActionAuthorized(Component component, String action) {
        if (action == null) {
            return true;
        }
        ISecurityCheck check = SecureComponentHelper.saveGetSecurityCheck(component);
        if (check != null) {
            return check.isActionAuthorized(SecureComponentHelper.getActionFactory().getAction(action));
        }
        if (SecureComponentHelper.hasSecureModel(component)) {
            return ((ISecureModel)component.getModel()).isAuthorized(component, SecureComponentHelper.getActionFactory().getAction(action));
        }
        return true;
    }

    public static boolean isActionAuthorized(Component component, WaspAction action) {
        if (action == null) {
            return true;
        }
        ISecurityCheck check = SecureComponentHelper.saveGetSecurityCheck(component);
        if (check != null) {
            return check.isActionAuthorized(action);
        }
        if (SecureComponentHelper.hasSecureModel(component)) {
            return ((ISecureModel)component.getModel()).isAuthorized(component, action);
        }
        return true;
    }

    public static boolean isAuthenticated(Component component) {
        ISecurityCheck check = SecureComponentHelper.saveGetSecurityCheck(component);
        if (check != null) {
            return check.isAuthenticated();
        }
        if (SecureComponentHelper.hasSecureModel(component)) {
            return ((ISecureModel)component.getModel()).isAuthenticated(component);
        }
        return true;
    }

    public static String alias(Component component) {
        if (component == null) {
            throw new SecurityException("Specified component is null");
        }
        Page page = null;
        try {
            page = component.getPage();
        }
        catch (IllegalStateException e) {
            throw new SecurityException("Unable to create alias for component: " + component, e);
        }
        String alias = SecureComponentHelper.alias(page.getClass());
        String relative = component.getPageRelativePath();
        if (relative == null || "".equals(relative)) {
            return alias;
        }
        return alias + ":" + relative;
    }

    public static String alias(Class class1) {
        if (class1 == null) {
            throw new SecurityException("Specified class is null");
        }
        return class1.getName();
    }
}

