/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.security.util.EmptyIterator;

public class ManyToManyMap {
    private static final long serialVersionUID = 1L;
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    private Map mappings;

    public ManyToManyMap() {
        this.mappings = new HashMap();
    }

    public ManyToManyMap(int initialCapacity) {
        this.mappings = new HashMap(initialCapacity);
    }

    public ManyToManyMap(int initialCapacity, float loadFactor) {
        this.mappings = new HashMap(initialCapacity, loadFactor);
    }

    public void add(Object left, Object right) {
        if (left == null) {
            throw new NullPointerException("left must not be null.");
        }
        if (right == null) {
            throw new NullPointerException("right must not be null.");
        }
        Set<Object> manys = (HashSet<Object>)this.mappings.get(left);
        if (manys == null) {
            manys = new HashSet<Object>();
        }
        manys.add(right);
        this.mappings.put(left, manys);
        manys = (Set)this.mappings.get(right);
        if (manys == null) {
            manys = new HashSet();
        }
        manys.add(left);
        this.mappings.put(right, manys);
    }

    public boolean remove(Object left, Object right) {
        Set manys = (Set)this.mappings.get(left);
        if (manys != null && manys.remove(right)) {
            if (manys.isEmpty()) {
                this.mappings.remove(left);
            }
            manys = (Set)this.mappings.get(right);
            manys.remove(left);
            if (manys.isEmpty()) {
                this.mappings.remove(right);
            }
            return true;
        }
        return false;
    }

    public Set removeAllMappings(Object leftOrRight) {
        Set manys = (Set)this.mappings.remove(leftOrRight);
        if (manys != null) {
            Iterator it = manys.iterator();
            Set temp = null;
            while (it.hasNext()) {
                Object next = it.next();
                temp = (Set)this.mappings.get(next);
                temp.remove(leftOrRight);
                if (!temp.isEmpty()) continue;
                this.mappings.remove(next);
            }
        }
        return manys;
    }

    public Set get(Object left) {
        Set set = (Set)this.mappings.get(left);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(set);
    }

    public int size() {
        return this.mappings.size();
    }

    public int numberOfmappings(Object value) {
        Set set = (Set)this.mappings.get(value);
        if (set == null) {
            return 0;
        }
        return set.size();
    }

    public boolean contains(Object key) {
        return this.mappings.containsKey(key);
    }

    public boolean isEmpty() {
        return this.mappings.isEmpty();
    }

    public void clear() {
        this.mappings.clear();
    }

    public Iterator iterator() {
        if (this.mappings.isEmpty()) {
            return EMPTY_ITERATOR;
        }
        return this.mappings.keySet().iterator();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ManyToManyMap) {
            return ((Object)this.mappings).equals(((ManyToManyMap)obj).mappings);
        }
        return false;
    }

    public int hashCode() {
        return 37 * ((Object)this.mappings).hashCode() + 1979;
    }

    public String toString() {
        return this.mappings.toString();
    }
}

