/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.hive.authorization.permissions;

import org.apache.wicket.security.actions.Inherit;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.hive.authorization.Permission;
import org.apache.wicket.security.swarm.actions.SwarmAction;

public class ActionPermission
extends Permission {
    private static final long serialVersionUID = 1L;
    private SwarmAction actions;

    protected ActionPermission(String name, SwarmAction actions) {
        super(name);
        if (name == null) {
            throw new IllegalArgumentException("Name is required.");
        }
        if (actions == null) {
            throw new IllegalArgumentException("Actions is required.");
        }
        this.actions = actions;
    }

    public boolean implies(Permission permission) {
        if (permission instanceof ActionPermission) {
            ActionPermission other = (ActionPermission)permission;
            if (this.actions.implies((WaspAction)ActionPermission.getAction(Inherit.class))) {
                return this.actions.implies((WaspAction)other.actions) && other.getName().startsWith(this.getName());
            }
            return this.actions.implies((WaspAction)other.actions) && this.getName().equals(other.getName());
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ActionPermission other = (ActionPermission)obj;
            return other.getName().equals(this.getName()) && other.actions.actions() == this.actions.actions();
        }
        return false;
    }

    public int hashCode() {
        int result = 4679;
        result = 37 * result + this.getClass().getName().hashCode();
        result = 37 * result + this.getName().hashCode();
        result = 37 * result + this.actions.hashCode();
        return result;
    }

    public final String getActions() {
        return this.actions.getName();
    }

    public String toString() {
        return this.getClass().getName() + " \"" + this.getName() + "\" \"" + this.getActions() + "\"";
    }

    public boolean hasAction(int myActions) {
        return this.actions.implies(myActions);
    }

    protected final SwarmAction getAction() {
        return this.actions;
    }
}

