/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.hive.authentication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.model.IModel;
import org.apache.wicket.security.hive.authentication.LoginContext;
import org.apache.wicket.security.hive.authentication.Subject;
import org.apache.wicket.security.strategies.LoginException;
import org.apache.wicket.util.string.AppendingStringBuffer;

public final class LoginContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List logins = new ArrayList();
    private Map subjects = new HashMap();
    private Subject subject = null;
    private HashKey preventsLogin = null;
    static /* synthetic */ Class class$org$apache$wicket$security$hive$authentication$LoginContext;

    public void login(LoginContext context) throws LoginException {
        if (this.preventsLogin != null) {
            throw new LoginException("Additional Logins are not allowed");
        }
        if (context == null) {
            throw new LoginException("Context is required to login.");
        }
        HashKey key = new HashKey(context);
        if (this.subjects.containsKey(key)) {
            throw new LoginException("Already logged in through this context ").setLoginContext((Object)context);
        }
        Subject mySubject = context.login();
        if (mySubject == null) {
            throw new LoginException("Login failed ").setLoginContext((Object)context);
        }
        mySubject.setReadOnly();
        if (key.preventsAdditionalLogins()) {
            this.preventsLogin = key;
        }
        this.subjects.put(key, mySubject);
        this.logins.add(key);
        Collections.sort(this.logins);
        this.subject = new MultiSubject(this.logins, this.subjects);
    }

    public boolean logoff(LoginContext context) {
        if (context == null) {
            return false;
        }
        HashKey key = new HashKey(context);
        Subject removed = (Subject)this.subjects.remove(key);
        if (removed != null) {
            if (this.preventsLogin != null && this.preventsLogin.equals(key)) {
                this.preventsLogin = null;
            }
            this.logins.remove(key);
            this.subject = this.logins.isEmpty() ? null : new MultiSubject(this.logins, this.subjects);
            Session.get().dirty();
            context.notifyLogoff(removed);
            return true;
        }
        return false;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public int size() {
        return this.logins.size();
    }

    public boolean isModelAuthenticated(IModel model, Component component) {
        return this.subject == null ? false : this.subject.isModelAuthenticated(model, component);
    }

    public boolean isComponentAuthenticated(Component component) {
        return this.subject == null ? false : this.subject.isComponentAuthenticated(component);
    }

    public boolean isClassAuthenticated(Class clazz) {
        return this.subject == null ? false : this.subject.isClassAuthenticated(clazz);
    }

    private static final class HashKey
    implements Serializable,
    Comparable {
        private static final long serialVersionUID = 1L;
        private final int contextHash;
        private final boolean preventsAdditionalLogin;
        private int sortOrder;
        private String toStringCache;

        public HashKey(LoginContext context) {
            this.contextHash = context.hashCode();
            this.preventsAdditionalLogin = context.preventsAdditionalLogins();
            this.sortOrder = context.getSortOrder();
            this.toStringCache = new AppendingStringBuffer(25).append("HashKey: ").append(this.contextHash).append(", sortOrder ").append(this.sortOrder).toString();
        }

        public String toString() {
            return this.toStringCache;
        }

        public int compareTo(Object arg0) {
            if (arg0 instanceof HashKey) {
                HashKey lc0 = (HashKey)arg0;
                return this.sortOrder - lc0.sortOrder;
            }
            throw new IllegalArgumentException("Can only compare with " + (class$org$apache$wicket$security$hive$authentication$LoginContext == null ? (class$org$apache$wicket$security$hive$authentication$LoginContext = LoginContainer.class$("org.apache.wicket.security.hive.authentication.LoginContext")) : class$org$apache$wicket$security$hive$authentication$LoginContext) + " not with " + arg0);
        }

        public int getContextHash() {
            return this.contextHash;
        }

        public boolean preventsAdditionalLogins() {
            return this.preventsAdditionalLogin;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.contextHash;
            result = 31 * result + (this.preventsAdditionalLogin ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HashKey other = (HashKey)obj;
            if (this.contextHash != other.contextHash) {
                return false;
            }
            return this.preventsAdditionalLogin == other.preventsAdditionalLogin;
        }
    }

    private static final class MultiSubject
    implements Subject {
        private static final long serialVersionUID = 1L;
        private Set principals;
        private Set readOnlyPrincipals;
        private final List keys;
        private final Map mySubjects;
        private transient String toStringCache = null;

        public MultiSubject(List keys, Map values) {
            this.keys = keys;
            this.mySubjects = values;
            this.principals = new HashSet(100);
            Iterator subjects = values.values().iterator();
            while (subjects.hasNext()) {
                this.principals.addAll(((Subject)subjects.next()).getPrincipals());
            }
            this.readOnlyPrincipals = Collections.unmodifiableSet(this.principals);
        }

        public Set getPrincipals() {
            return this.readOnlyPrincipals;
        }

        public boolean isReadOnly() {
            return true;
        }

        public void setReadOnly() {
        }

        public boolean isModelAuthenticated(IModel model, Component component) {
            HashKey ctx = null;
            for (int i = 0; i < this.keys.size(); ++i) {
                ctx = (HashKey)this.keys.get(i);
                if (!((Subject)this.mySubjects.get(ctx)).isModelAuthenticated(model, component)) continue;
                return true;
            }
            return false;
        }

        public boolean isComponentAuthenticated(Component component) {
            HashKey ctx = null;
            for (int i = 0; i < this.keys.size(); ++i) {
                ctx = (HashKey)this.keys.get(i);
                if (!((Subject)this.mySubjects.get(ctx)).isComponentAuthenticated(component)) continue;
                return true;
            }
            return false;
        }

        public boolean isClassAuthenticated(Class clazz) {
            HashKey ctx = null;
            for (int i = 0; i < this.keys.size(); ++i) {
                ctx = (HashKey)this.keys.get(i);
                if (!((Subject)this.mySubjects.get(ctx)).isClassAuthenticated(clazz)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            if (this.toStringCache != null) {
                return this.toStringCache;
            }
            AppendingStringBuffer buffer = new AppendingStringBuffer(10 + this.mySubjects.size() * 25);
            buffer.append("Subjects[");
            boolean comma = false;
            HashKey ctx = null;
            for (int i = 0; i < this.keys.size(); ++i) {
                ctx = (HashKey)this.keys.get(i);
                buffer.append((Object)ctx).append(" = ").append(this.mySubjects.get(ctx));
                if (comma) {
                    buffer.append(", ");
                    continue;
                }
                comma = true;
            }
            buffer.append("]");
            this.toStringCache = buffer.toString();
            return this.toStringCache;
        }
    }
}

