/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.proxy.bytebuddy;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.function.Function;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Pipe;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.proxy.ILazyInitProxy;
import org.apache.wicket.proxy.IProxyFactory;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.LazyInitProxyFactory;
import org.apache.wicket.proxy.bytebuddy.ByteBuddyInterceptor;
import org.apache.wicket.proxy.objenesis.IInstantiator;

public class ByteBuddyProxyFactory
implements IProxyFactory {
    private static final TypeCache<TypeCache.SimpleKey> DYNAMIC_CLASS_CACHE = new TypeCache.WithInlineExpunction(TypeCache.Sort.SOFT);
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy().with((NamingStrategy)WicketNamingStrategy.INSTANCE);
    private static final String INTERCEPTOR_FIELD_NAME = "interceptor";
    private static final IInstantiator INSTANTIATOR = IInstantiator.getInstantiator();

    @Override
    public <T> T createProxy(Class<T> type, IProxyTargetLocator locator) {
        T instance;
        Class<T> proxyClass = ByteBuddyProxyFactory.createOrGetProxyClass(type);
        if (!ByteBuddyProxyFactory.hasNoArgConstructor(type)) {
            instance = INSTANTIATOR.newInstance(proxyClass);
        } else {
            try {
                instance = proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        ByteBuddyInterceptor interceptor = new ByteBuddyInterceptor(type, locator);
        ((InterceptorMutator)instance).setInterceptor(interceptor);
        return instance;
    }

    public static <T> Class<T> createOrGetProxyClass(Class<T> type) {
        ClassLoader classLoader = ByteBuddyProxyFactory.resolveClassLoader();
        return DYNAMIC_CLASS_CACHE.findOrInsert(classLoader, (Object)new TypeCache.SimpleKey(type, new Class[0]), () -> BYTE_BUDDY.subclass(type).method((ElementMatcher)ElementMatchers.isPublic()).intercept((Implementation)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{Pipe.Binder.install(Function.class)}).toField(INTERCEPTOR_FIELD_NAME)).defineField(INTERCEPTOR_FIELD_NAME, ByteBuddyInterceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).implement(new Type[]{InterceptorMutator.class}).intercept((Implementation)FieldAccessor.ofBeanProperty()).implement(new Type[]{Serializable.class, LazyInitProxyFactory.IWriteReplace.class, ILazyInitProxy.class}).intercept((Implementation)MethodDelegation.toField((String)INTERCEPTOR_FIELD_NAME)).make().load(classLoader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded());
    }

    private static ClassLoader resolveClassLoader() {
        ClassLoader classLoader = null;
        if (Application.exists()) {
            classLoader = Application.get().getApplicationSettings().getClassResolver().getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    private static boolean hasNoArgConstructor(Class<?> type) {
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    private static final class WicketNamingStrategy
    extends NamingStrategy.AbstractBase {
        public static final WicketNamingStrategy INSTANCE = new WicketNamingStrategy();

        private WicketNamingStrategy() {
        }

        protected String name(TypeDescription superClass) {
            String prefix = superClass.getName();
            int lastIdxOfDot = prefix.lastIndexOf(46);
            String packageName = prefix.substring(0, lastIdxOfDot);
            String className = prefix.substring(lastIdxOfDot + 1);
            String name = packageName + ".";
            name = prefix.startsWith("java.") ? "bytebuddy_generated_wicket_proxy." + name + className : name + "WicketProxy_" + className;
            return name;
        }

        public String redefine(TypeDescription typeDescription) {
            return typeDescription.getName();
        }

        public String rebase(TypeDescription typeDescription) {
            return typeDescription.getName();
        }
    }

    public static interface InterceptorMutator {
        public void setInterceptor(ByteBuddyInterceptor var1);
    }
}

