/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.extensions.ajax.markup.html.AjaxLazyLoadPanel;
import org.apache.wicket.util.tester.BaseWicketTester;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxLazyLoadPanelTester {
    private static final Logger logger = LoggerFactory.getLogger(AjaxLazyLoadPanelTester.class);

    public static void executeAjaxLazyLoadPanel(BaseWicketTester wt) {
        AjaxLazyLoadPanelTester.executeAjaxLazyLoadPanel(wt, wt.getLastRenderedPage());
    }

    public static void executeAjaxLazyLoadPanel(BaseWicketTester wt, Page page) {
        List behaviors = page.getBehaviors(AjaxLazyLoadPanel.AjaxLazyLoadTimer.class);
        if (behaviors.size() == 0) {
            logger.warn("No timer behavior for AjaxLazyLoadPanel found. A curious situation...");
            return;
        }
        if (behaviors.size() > 1) {
            logger.warn("Multiple timer behavior for AjaxLazyLoadPanel found. A curious situation...");
        }
        wt.executeBehavior((AbstractAjaxBehavior)behaviors.get(0));
    }

    public static Duration loadAjaxLazyLoadPanel(BaseWicketTester wt, AjaxLazyLoadPanel<?> panel) {
        if (panel.isLoaded()) {
            return null;
        }
        return panel.getUpdateInterval();
    }
}

