/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tabs;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;

public class TabbedPanel<T extends ITab>
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String TAB_PANEL_ID = "panel";
    private final List<T> tabs;
    private int currentTab = -1;
    private transient Boolean[] tabsVisibilityCache;

    public TabbedPanel(String id, List<T> tabs) {
        this(id, tabs, null);
    }

    public TabbedPanel(String id, List<T> tabs, IModel<Integer> model) {
        super(id, model);
        this.tabs = (List)Args.notNull(tabs, (String)"tabs");
        AbstractReadOnlyModel<Integer> tabCount = new AbstractReadOnlyModel<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                return TabbedPanel.this.tabs.size();
            }
        };
        WebMarkupContainer tabsContainer = this.newTabsContainer("tabs-container");
        this.add(new Component[]{tabsContainer});
        tabsContainer.add(new Component[]{new Loop("tabs", (IModel)tabCount){
            private static final long serialVersionUID = 1L;

            protected void populateItem(LoopItem item) {
                int index = item.getIndex();
                ITab tab = (ITab)TabbedPanel.this.tabs.get(index);
                WebMarkupContainer titleLink = TabbedPanel.this.newLink("link", index);
                titleLink.add(new Component[]{TabbedPanel.this.newTitle("title", tab.getTitle(), index)});
                item.add(new Component[]{titleLink});
            }

            protected LoopItem newItem(int iteration) {
                return TabbedPanel.this.newTabContainer(iteration);
            }
        }});
        this.add(new Component[]{this.newPanel()});
    }

    protected IModel<?> initModel() {
        IModel model = super.initModel();
        if (model == null) {
            model = new Model((Serializable)Integer.valueOf(-1));
        }
        return model;
    }

    protected WebMarkupContainer newTabsContainer(String id) {
        return new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("class", (CharSequence)TabbedPanel.this.getTabContainerCssClass());
            }
        };
    }

    protected LoopItem newTabContainer(final int tabIndex) {
        return new LoopItem(tabIndex){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String cssClass = tag.getAttribute("class");
                if (cssClass == null) {
                    cssClass = " ";
                }
                cssClass = cssClass + " tab" + this.getIndex();
                if (this.getIndex() == TabbedPanel.this.getSelectedTab()) {
                    cssClass = cssClass + ' ' + TabbedPanel.this.getSelectedTabCssClass();
                }
                if (this.getIndex() == TabbedPanel.this.getTabs().size() - 1) {
                    cssClass = cssClass + ' ' + TabbedPanel.this.getLastTabCssClass();
                }
                tag.put("class", (CharSequence)cssClass.trim());
            }

            public boolean isVisible() {
                return ((ITab)TabbedPanel.this.getTabs().get(tabIndex)).isVisible();
            }
        };
    }

    protected void onBeforeRender() {
        int index = this.getSelectedTab();
        if (index == -1 || !this.isTabVisible(index)) {
            index = -1;
            for (int i = 0; i < this.tabs.size(); ++i) {
                if (!this.isTabVisible(i)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.setSelectedTab(index);
            }
        }
        this.setCurrentTab(index);
        super.onBeforeRender();
    }

    protected String getTabContainerCssClass() {
        return "tab-row";
    }

    protected String getLastTabCssClass() {
        return "last";
    }

    protected String getSelectedTabCssClass() {
        return "selected";
    }

    public final List<T> getTabs() {
        return this.tabs;
    }

    protected Component newTitle(String titleId, IModel<?> titleModel, int index) {
        return new Label(titleId, titleModel);
    }

    protected WebMarkupContainer newLink(String linkId, final int index) {
        return new Link<Void>(linkId){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                TabbedPanel.this.setSelectedTab(index);
            }
        };
    }

    public TabbedPanel<T> setSelectedTab(int index) {
        if (index < 0 || index >= this.tabs.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.setDefaultModelObject(index);
        this.currentTab = -1;
        this.setCurrentTab(index);
        return this;
    }

    private void setCurrentTab(int index) {
        WebMarkupContainer component;
        if (this.currentTab == index) {
            return;
        }
        this.currentTab = index;
        if (this.currentTab == -1 || this.tabs.size() == 0 || !this.isTabVisible(this.currentTab)) {
            component = this.newPanel();
        } else {
            ITab tab = (ITab)this.tabs.get(this.currentTab);
            component = tab.getPanel(TAB_PANEL_ID);
            if (component == null) {
                throw new WicketRuntimeException("ITab.getPanel() returned null. TabbedPanel [" + this.getPath() + "] ITab index [" + this.currentTab + "]");
            }
        }
        if (!component.getId().equals(TAB_PANEL_ID)) {
            throw new WicketRuntimeException("ITab.getPanel() returned a panel with invalid id [" + component.getId() + "]. You must always return a panel with id equal to the provided panelId parameter. TabbedPanel [" + this.getPath() + "] ITab index [" + this.currentTab + "]");
        }
        this.addOrReplace(new Component[]{component});
    }

    private WebMarkupContainer newPanel() {
        return new WebMarkupContainer(TAB_PANEL_ID);
    }

    public final int getSelectedTab() {
        return (Integer)this.getDefaultModelObject();
    }

    private boolean isTabVisible(int tabIndex) {
        if (this.tabsVisibilityCache == null) {
            this.tabsVisibilityCache = new Boolean[this.tabs.size()];
        }
        if (this.tabsVisibilityCache.length < tabIndex + 1) {
            Boolean[] resized = new Boolean[tabIndex + 1];
            System.arraycopy(this.tabsVisibilityCache, 0, resized, 0, this.tabsVisibilityCache.length);
            this.tabsVisibilityCache = resized;
        }
        if (this.tabsVisibilityCache.length > 0) {
            Boolean visible = this.tabsVisibilityCache[tabIndex];
            if (visible == null) {
                this.tabsVisibilityCache[tabIndex] = visible = Boolean.valueOf(((ITab)this.tabs.get(tabIndex)).isVisible());
            }
            return visible;
        }
        return false;
    }

    protected void onDetach() {
        this.tabsVisibilityCache = null;
        super.onDetach();
    }
}

