/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.AjaxEditableLabel;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxEditableMultiLineLabel<T>
extends AjaxEditableLabel<T> {
    private static final long serialVersionUID = 1L;
    private int rows = 10;
    private int cols = 40;

    public AjaxEditableMultiLineLabel(String id) {
        super(id);
    }

    public AjaxEditableMultiLineLabel(String id, IModel<T> model) {
        super(id, model);
    }

    protected MultiLineLabel newLabel(MarkupContainer parent, String componentId, IModel<T> model) {
        MultiLineLabel label = new MultiLineLabel(componentId, model){
            private static final long serialVersionUID = 1L;

            public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                Object modelObject = this.getDefaultModelObject();
                if (modelObject == null || "".equals(modelObject)) {
                    this.replaceComponentTagBody(markupStream, openTag, AjaxEditableMultiLineLabel.this.defaultNullLabel());
                } else {
                    super.onComponentTagBody(markupStream, openTag);
                }
            }
        };
        label.setOutputMarkupId(true);
        label.add(new Behavior[]{new AjaxEditableLabel.LabelAjaxBehavior(this, this.getLabelAjaxEvent())});
        return label;
    }

    @Override
    protected String getLabelAjaxEvent() {
        return "onclick";
    }

    @Override
    protected FormComponent<T> newEditor(MarkupContainer parent, String componentId, IModel<T> model) {
        TextArea editor = new TextArea<T>(componentId, model){
            private static final long serialVersionUID = 1L;

            protected void onModelChanged() {
                AjaxEditableMultiLineLabel.this.onModelChanged();
            }

            protected void onModelChanging() {
                AjaxEditableMultiLineLabel.this.onModelChanging();
            }
        };
        editor.add(new Behavior[]{new AttributeModifier("rows", (IModel)new AbstractReadOnlyModel<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                return AjaxEditableMultiLineLabel.this.rows;
            }
        })});
        editor.add(new Behavior[]{new AttributeModifier("cols", (IModel)new AbstractReadOnlyModel<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                return AjaxEditableMultiLineLabel.this.cols;
            }
        })});
        editor.setOutputMarkupId(true);
        editor.setVisible(false);
        editor.add(new Behavior[]{new AjaxEditableLabel.EditorAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String saveCall = "{wicketAjaxPost('" + this.getCallbackUrl() + "&save=true', " + "wicketSerialize(this)); return true;}";
                String cancelCall = "{wicketAjaxGet('" + this.getCallbackUrl() + "&save=false');this.onblur='';return false;}";
                String keypress = "var kc=wicketKeyCode(event); if (kc==27) " + cancelCall + "; ";
                tag.put("onblur", (CharSequence)saveCall);
                tag.put("onkeydown", (CharSequence)keypress);
            }
        }});
        return editor;
    }

    public final int getCols() {
        return this.cols;
    }

    public final void setCols(int cols) {
        this.cols = cols;
    }

    public final int getRows() {
        return this.rows;
    }

    public final void setRows(int rows) {
        this.rows = rows;
    }

    @Override
    protected String defaultNullLabel() {
        return "...";
    }

    @Override
    protected void onModelChanged() {
        super.onModelChanged();
    }

    @Override
    protected void onModelChanging() {
        super.onModelChanging();
    }
}

