/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tabs;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabbedPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String TAB_PANEL_ID = "panel";
    private final List<ITab> tabs;
    private transient Boolean[] tabsVisibilityCache;

    public TabbedPanel(String id, List<ITab> tabs) {
        super(id, (IModel)new Model((Serializable)new Integer(-1)));
        if (tabs == null) {
            throw new IllegalArgumentException("argument [tabs] cannot be null");
        }
        this.tabs = tabs;
        AbstractReadOnlyModel<Integer> tabCount = new AbstractReadOnlyModel<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                return TabbedPanel.this.tabs.size();
            }
        };
        WebMarkupContainer tabsContainer = this.newTabsContainer("tabs-container");
        this.add(new Component[]{tabsContainer});
        tabsContainer.add(new Component[]{new Loop("tabs", (IModel)tabCount){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Loop.LoopItem item) {
                int index = item.getIteration();
                ITab tab = (ITab)TabbedPanel.this.tabs.get(index);
                WebMarkupContainer titleLink = TabbedPanel.this.newLink("link", index);
                titleLink.add(new Component[]{TabbedPanel.this.newTitle("title", tab.getTitle(), index)});
                item.add(new Component[]{titleLink});
            }

            protected Loop.LoopItem newItem(int iteration) {
                return TabbedPanel.this.newTabContainer(iteration);
            }
        }});
    }

    protected WebMarkupContainer newTabsContainer(String id) {
        return new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("class", (CharSequence)TabbedPanel.this.getTabContainerCssClass());
            }
        };
    }

    protected Loop.LoopItem newTabContainer(final int tabIndex) {
        return new Loop.LoopItem(tabIndex){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String cssClass = (String)tag.getString("class");
                if (cssClass == null) {
                    cssClass = " ";
                }
                cssClass = cssClass + " tab" + this.getIteration();
                if (this.getIteration() == TabbedPanel.this.getSelectedTab()) {
                    cssClass = cssClass + " selected";
                }
                if (this.getIteration() == TabbedPanel.this.getTabs().size() - 1) {
                    cssClass = cssClass + " last";
                }
                tag.put("class", (CharSequence)cssClass.trim());
            }

            public boolean isVisible() {
                return TabbedPanel.this.getTabs().get(tabIndex).isVisible();
            }
        };
    }

    protected void onBeforeRender() {
        if (this.getSelectedTab() == -1 || !this.isTabVisible(this.getSelectedTab())) {
            int selected = 0;
            for (int i = 0; i < this.tabs.size(); ++i) {
                if (!this.isTabVisible(i)) continue;
                selected = i;
                break;
            }
            if (selected == this.tabs.size()) {
                selected = 0;
            }
            this.setSelectedTab(selected);
        }
        super.onBeforeRender();
    }

    protected String getTabContainerCssClass() {
        return "tab-row";
    }

    public final List<ITab> getTabs() {
        return this.tabs;
    }

    protected Component newTitle(String titleId, IModel<?> titleModel, int index) {
        return new Label(titleId, titleModel);
    }

    protected WebMarkupContainer newLink(String linkId, final int index) {
        return new Link<Void>(linkId){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                TabbedPanel.this.setSelectedTab(index);
            }
        };
    }

    public void setSelectedTab(int index) {
        WebMarkupContainer component;
        if (index < 0 || index >= this.tabs.size() && index > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setDefaultModelObject(new Integer(index));
        if (this.tabs.size() == 0 || !this.isTabVisible(index)) {
            component = new WebMarkupContainer(TAB_PANEL_ID);
        } else {
            ITab tab = this.tabs.get(index);
            component = tab.getPanel(TAB_PANEL_ID);
            if (component == null) {
                throw new WicketRuntimeException("ITab.getPanel() returned null. TabbedPanel [" + this.getPath() + "] ITab index [" + index + "]");
            }
        }
        if (!component.getId().equals(TAB_PANEL_ID)) {
            throw new WicketRuntimeException("ITab.getPanel() returned a panel with invalid id [" + component.getId() + "]. You must always return a panel with id equal to the provided panelId parameter. TabbedPanel [" + this.getPath() + "] ITab index [" + index + "]");
        }
        this.addOrReplace(new Component[]{component});
    }

    public final int getSelectedTab() {
        return (Integer)this.getDefaultModelObject();
    }

    private boolean isTabVisible(int tabIndex) {
        if (this.tabsVisibilityCache == null) {
            this.tabsVisibilityCache = new Boolean[this.tabs.size()];
        }
        if (this.tabsVisibilityCache.length < tabIndex + 1) {
            Boolean[] resized = new Boolean[tabIndex + 1];
            System.arraycopy(this.tabsVisibilityCache, 0, resized, 0, this.tabsVisibilityCache.length);
            this.tabsVisibilityCache = resized;
        }
        if (this.tabsVisibilityCache.length > 0) {
            Boolean visible = this.tabsVisibilityCache[tabIndex];
            if (visible == null) {
                this.tabsVisibilityCache[tabIndex] = visible = Boolean.valueOf(this.tabs.get(tabIndex).isVisible());
            }
            return visible;
        }
        return false;
    }

    protected void onDetach() {
        this.tabsVisibilityCache = null;
        super.onDetach();
    }
}

