/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.palette;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.extensions.markup.html.form.palette.component.Choices;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.extensions.markup.html.form.palette.component.Selection;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.StyleSheetReference;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Palette<T>
extends Panel
implements IHeaderContributor {
    private static final String SELECTED_HEADER_ID = "selectedHeader";
    private static final String AVAILABLE_HEADER_ID = "availableHeader";
    private static final long serialVersionUID = 1L;
    private final IModel<Collection<T>> choicesModel;
    private final IChoiceRenderer<T> choiceRenderer;
    private final int rows;
    private final boolean allowOrder;
    private Recorder<T> recorderComponent;
    private Component choicesComponent;
    private Component selectionComponent;
    private static final ResourceReference JAVASCRIPT = new ResourceReference(Palette.class, "palette.js");
    private static final ResourceReference CSS = new ResourceReference(Palette.class, "palette.css");
    private static final ResourceReference UP_IMAGE = new ResourceReference(Palette.class, "up.gif");
    private static final ResourceReference DOWN_IMAGE = new ResourceReference(Palette.class, "down.gif");
    private static final ResourceReference REMOVE_IMAGE = new ResourceReference(Palette.class, "remove.gif");
    private static final ResourceReference ADD_IMAGE = new ResourceReference(Palette.class, "add.gif");

    public Palette(String id, IModel<Collection<T>> choicesModel, IChoiceRenderer<T> choiceRenderer, int rows, boolean allowOrder) {
        this(id, null, choicesModel, choiceRenderer, rows, allowOrder);
    }

    public Palette(String id, IModel<List<T>> model, IModel<Collection<T>> choicesModel, IChoiceRenderer<T> choiceRenderer, int rows, boolean allowOrder) {
        super(id, model);
        this.choicesModel = choicesModel;
        this.choiceRenderer = choiceRenderer;
        this.rows = rows;
        this.allowOrder = allowOrder;
    }

    protected void onBeforeRender() {
        if (this.get("recorder") == null) {
            this.initFactories();
        }
        super.onBeforeRender();
    }

    private void initFactories() {
        this.recorderComponent = this.newRecorderComponent();
        this.add(new Component[]{this.recorderComponent});
        this.choicesComponent = this.newChoicesComponent();
        this.add(new Component[]{this.choicesComponent});
        this.selectionComponent = this.newSelectionComponent();
        this.add(new Component[]{this.selectionComponent});
        this.add(new Component[]{this.newAddComponent()});
        this.add(new Component[]{this.newRemoveComponent()});
        this.add(new Component[]{this.newUpComponent().setVisible(this.allowOrder)});
        this.add(new Component[]{this.newDownComponent().setVisible(this.allowOrder)});
        this.add(new Component[]{this.newAvailableHeader(AVAILABLE_HEADER_ID)});
        this.add(new Component[]{this.newSelectedHeader(SELECTED_HEADER_ID)});
    }

    protected ResourceReference getCSS() {
        return CSS;
    }

    protected StyleSheetReference getStyleSheet() {
        return new StyleSheetReference("paletteCSS", ((Object)((Object)this)).getClass(), "palette.css");
    }

    public final boolean isPaletteEnabled() {
        return this.isEnabledInHierarchy();
    }

    public Iterator<T> getSelectedChoices() {
        return this.getRecorderComponent().getSelectedChoices();
    }

    public Iterator<T> getUnselectedChoices() {
        return this.getRecorderComponent().getUnselectedChoices();
    }

    protected Recorder<T> newRecorderComponent() {
        return new Recorder<T>("recorder", this){
            private static final long serialVersionUID = 1L;

            public void updateModel() {
                super.updateModel();
                Palette.this.updateModel();
            }
        };
    }

    protected Component newAvailableHeader(String componentId) {
        return new Label(componentId, (IModel)new ResourceModel("palette.available", "Available"));
    }

    protected Component newSelectedHeader(String componentId) {
        return new Label(componentId, (IModel)new ResourceModel("palette.selected", "Selected"));
    }

    protected Component newDownComponent() {
        return new PaletteButton("moveDownButton"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getDownOnClickJS());
            }
        }.add(new Component[]{new Image("image", DOWN_IMAGE)});
    }

    protected Component newUpComponent() {
        return new PaletteButton("moveUpButton"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getUpOnClickJS());
            }
        }.add(new Component[]{new Image("image", UP_IMAGE)});
    }

    protected Component newRemoveComponent() {
        return new PaletteButton("removeButton"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getRemoveOnClickJS());
            }
        }.add(new Component[]{new Image("image", REMOVE_IMAGE)});
    }

    protected Component newAddComponent() {
        return new PaletteButton("addButton"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getAddOnClickJS());
            }
        }.add(new Component[]{new Image("image", ADD_IMAGE)});
    }

    protected Component newSelectionComponent() {
        return new Selection<T>("selection", this){
            private static final long serialVersionUID = 1L;

            @Override
            protected Map<String, String> getAdditionalAttributes(Object choice) {
                return Palette.this.getAdditionalAttributesForSelection(choice);
            }
        };
    }

    protected Map<String, String> getAdditionalAttributesForSelection(Object choice) {
        return null;
    }

    protected Component newChoicesComponent() {
        return new Choices<T>("choices", this){
            private static final long serialVersionUID = 1L;

            @Override
            protected Map<String, String> getAdditionalAttributes(Object choice) {
                return Palette.this.getAdditionalAttributesForChoices(choice);
            }
        };
    }

    protected Map<String, String> getAdditionalAttributesForChoices(Object choice) {
        return null;
    }

    private Component getChoicesComponent() {
        return this.choicesComponent;
    }

    private Component getSelectionComponent() {
        return this.selectionComponent;
    }

    public final Recorder<T> getRecorderComponent() {
        return this.recorderComponent;
    }

    public Collection<T> getChoices() {
        return (Collection)this.choicesModel.getObject();
    }

    public Collection<T> getModelCollection() {
        return (Collection)this.getDefaultModelObject();
    }

    public IChoiceRenderer<T> getChoiceRenderer() {
        return this.choiceRenderer;
    }

    public int getRows() {
        return this.rows;
    }

    protected final void updateModel() {
        Collection<T> model = this.getModelCollection();
        model.clear();
        Iterator<T> it = this.getRecorderComponent().getSelectedChoices();
        while (it.hasNext()) {
            T selectedChoice = it.next();
            model.add(selectedChoice);
        }
        this.setDefaultModelObject(model);
    }

    protected String buildJSCall(String funcName) {
        return new StringBuffer(funcName).append("('").append(this.getChoicesComponent().getMarkupId()).append("','").append(this.getSelectionComponent().getMarkupId()).append("','").append(this.getRecorderComponent().getMarkupId()).append("');").toString();
    }

    public String getChoicesOnFocusJS() {
        return this.buildJSCall("Wicket.Palette.choicesOnFocus");
    }

    public String getSelectionOnFocusJS() {
        return this.buildJSCall("Wicket.Palette.selectionOnFocus");
    }

    public String getAddOnClickJS() {
        return this.buildJSCall("Wicket.Palette.add");
    }

    public String getRemoveOnClickJS() {
        return this.buildJSCall("Wicket.Palette.remove");
    }

    public String getUpOnClickJS() {
        return this.buildJSCall("Wicket.Palette.moveUp");
    }

    public String getDownOnClickJS() {
        return this.buildJSCall("Wicket.Palette.moveDown");
    }

    protected void onDetach() {
        this.choicesModel.detach();
        super.onDetach();
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference(JAVASCRIPT);
        ResourceReference css = this.getCSS();
        if (css != null) {
            response.renderCSSReference(css);
        }
    }

    private class PaletteButton
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;

        public PaletteButton(String id) {
            super(id);
        }

        protected void onComponentTag(ComponentTag tag) {
            if (!Palette.this.isPaletteEnabled()) {
                tag.getAttributes().put((Object)"disabled", (Object)"disabled");
            }
        }
    }
}

