/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.breadcrumb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.breadcrumb.BreadCrumbLink;
import org.apache.wicket.extensions.breadcrumb.DefaultBreadCrumbsModel;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModel;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModelListener;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbParticipant;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class BreadCrumbBar
extends Panel
implements IBreadCrumbModel {
    private static final long serialVersionUID = 1L;
    private final IBreadCrumbModel decorated = new DefaultBreadCrumbsModel();

    public BreadCrumbBar(String id) {
        super(id);
        BreadCrumbsListView breadCrumbsListView = new BreadCrumbsListView("crumbs");
        this.addListener(breadCrumbsListView);
        this.add((Component)breadCrumbsListView);
    }

    public void addListener(IBreadCrumbModelListener listener) {
        this.decorated.addListener(listener);
    }

    public List allBreadCrumbParticipants() {
        return this.decorated.allBreadCrumbParticipants();
    }

    public IBreadCrumbParticipant getActive() {
        return this.decorated.getActive();
    }

    public void removeListener(IBreadCrumbModelListener listener) {
        this.decorated.removeListener(listener);
    }

    public void setActive(IBreadCrumbParticipant breadCrumbParticipant) {
        this.decorated.setActive(breadCrumbParticipant);
    }

    protected boolean getEnableLinkToCurrent() {
        return false;
    }

    protected String getSeparatorMarkup() {
        return "/";
    }

    protected Component newBreadCrumbComponent(String id, int index, int total, IBreadCrumbParticipant breadCrumbParticipant) {
        boolean enableLink = this.getEnableLinkToCurrent() || index < total - 1;
        return new BreadCrumbComponent(id, this.getSeparatorMarkup(), index, this, breadCrumbParticipant, enableLink);
    }

    protected void onDetach() {
        super.onDetach();
        Iterator i = this.decorated.allBreadCrumbParticipants().iterator();
        while (i.hasNext()) {
            IBreadCrumbParticipant crumb = (IBreadCrumbParticipant)i.next();
            if (crumb instanceof Component) {
                ((Component)crumb).detach();
                continue;
            }
            if (!(crumb instanceof IDetachable)) continue;
            ((IDetachable)crumb).detach();
        }
    }

    protected class BreadCrumbsListView
    extends ListView
    implements IBreadCrumbModelListener {
        private static final long serialVersionUID = 1L;
        private transient boolean dirty;
        private transient int size;

        public BreadCrumbsListView(String id) {
            super(id);
            this.dirty = false;
            this.setReuseItems(false);
            this.setModel((IModel)new LoadableDetachableModel(){
                private static final long serialVersionUID = 1L;

                protected Object load() {
                    ArrayList l = new ArrayList(BreadCrumbBar.this.allBreadCrumbParticipants());
                    BreadCrumbsListView.this.size = l.size();
                    return l;
                }
            });
        }

        public void breadCrumbActivated(IBreadCrumbParticipant previousParticipant, IBreadCrumbParticipant breadCrumbParticipant) {
            this.signalModelChange();
        }

        public void breadCrumbAdded(IBreadCrumbParticipant breadCrumbParticipant) {
        }

        public void breadCrumbRemoved(IBreadCrumbParticipant breadCrumbParticipant) {
        }

        private void signalModelChange() {
            this.getModel().detach();
            super.internalOnAttach();
        }

        protected void onBeforeRender() {
            super.onBeforeRender();
            if (this.dirty) {
                this.dirty = false;
            }
        }

        protected void populateItem(ListItem item) {
            int index = item.getIndex();
            IBreadCrumbParticipant breadCrumbParticipant = (IBreadCrumbParticipant)item.getModelObject();
            item.add(BreadCrumbBar.this.newBreadCrumbComponent("crumb", index, this.size, breadCrumbParticipant));
        }
    }

    private static final class BreadCrumbComponent
    extends Panel {
        private static final long serialVersionUID = 1L;

        public BreadCrumbComponent(String id, String separatorMarkup, int index, IBreadCrumbModel breadCrumbModel, final IBreadCrumbParticipant breadCrumbParticipant, boolean enableLink) {
            super(id);
            this.add(new Label("sep", index > 0 ? separatorMarkup : "").setEscapeModelStrings(false).setRenderBodyOnly(true));
            BreadCrumbLink link = new BreadCrumbLink("link", breadCrumbModel){
                private static final long serialVersionUID = 1L;

                protected IBreadCrumbParticipant getParticipant(String componentId) {
                    return breadCrumbParticipant;
                }
            };
            link.setEnabled(enableLink);
            this.add((Component)link);
            link.add(new Label("label", breadCrumbParticipant.getTitle()).setRenderBodyOnly(true));
        }
    }
}

