/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Pair;
import com.taobao.weex.utils.SingleFunctionParser;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class WXResourceUtils {
    private static final Map<String, Integer> colorMap = new HashMap<String, Integer>();
    private static final int RGB_SIZE = 3;
    private static final int RGBA_SIZE = 4;
    private static final int HEX = 16;
    private static final int COLOR_RANGE = 255;
    private static final String RGB = "rgb";
    private static final String RGBA = "rgba";
    private static final SingleFunctionParser.FlatMapper<Integer> FUNCTIONAL_RGB_MAPPER = new SingleFunctionParser.FlatMapper<Integer>(){

        @Override
        public Integer map(String raw) {
            int color = WXUtils.parseUnitOrPercent(raw, 255);
            if (color < 0) {
                color = 0;
            } else if (color > 255) {
                color = 255;
            }
            return color;
        }
    };
    private static final SingleFunctionParser.NonUniformMapper<Number> FUNCTIONAL_RGBA_MAPPER = new SingleFunctionParser.NonUniformMapper<Number>(){

        @Override
        public List<Number> map(List<String> raw) {
            int i;
            ArrayList<Number> result = new ArrayList<Number>(4);
            for (i = 0; i < 3; ++i) {
                int color = WXUtils.parseUnitOrPercent(raw.get(i), 255);
                if (color < 0) {
                    color = 0;
                } else if (color > 255) {
                    color = 255;
                }
                result.add(color);
            }
            result.add(Float.valueOf(raw.get(i)));
            return result;
        }
    };

    public static int getColor(String color) {
        return WXResourceUtils.getColor(color, Integer.MIN_VALUE);
    }

    public static int getColor(String color, int defaultColor) {
        ColorConvertHandler[] handlers;
        if (TextUtils.isEmpty((CharSequence)color)) {
            return defaultColor;
        }
        Integer cache = (Integer)WXUtils.sCache.get((Object)(color = color.trim()));
        if (cache != null) {
            return cache;
        }
        int resultColor = defaultColor;
        for (ColorConvertHandler handler : handlers = ColorConvertHandler.values()) {
            try {
                Pair<Boolean, Integer> result = handler.handle(color);
                if (!((Boolean)result.first).booleanValue()) continue;
                resultColor = (Integer)result.second;
                WXUtils.sCache.put((Object)color, (Object)resultColor);
                break;
            }
            catch (RuntimeException e) {
                WXLogUtils.v("Color_Parser", WXLogUtils.getStackTrace(e));
            }
        }
        return resultColor;
    }

    public static Shader getShader(String image, float width, float height) {
        List<String> valueList = WXResourceUtils.parseGradientValues(image);
        if (valueList != null && valueList.size() == 3) {
            float[] points = WXResourceUtils.parseGradientDirection(valueList.get(0), width, height);
            LinearGradient shader = new LinearGradient(points[0], points[1], points[2], points[3], WXResourceUtils.getColor(valueList.get(1), -1), WXResourceUtils.getColor(valueList.get(2), -1), Shader.TileMode.CLAMP);
            return shader;
        }
        return null;
    }

    @NonNull
    private static List<String> parseGradientValues(String image) {
        if (TextUtils.isEmpty((CharSequence)image)) {
            return null;
        }
        image.trim();
        if (image.startsWith("linear-gradient")) {
            String valueStr = image.substring(image.indexOf("(") + 1, image.lastIndexOf(")"));
            StringTokenizer tokenizer = new StringTokenizer(valueStr, ",");
            ArrayList<String> values = new ArrayList<String>();
            String temp = null;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.contains("(")) {
                    temp = token + ",";
                    continue;
                }
                if (token.contains(")")) {
                    temp = temp + token;
                    values.add(temp);
                    temp = null;
                    continue;
                }
                if (temp != null) {
                    temp = temp + token + ",";
                    continue;
                }
                values.add(token);
            }
            return values;
        }
        return null;
    }

    private static float[] parseGradientDirection(String direction, float width, float height) {
        int x1 = 0;
        int y1 = 1;
        int x2 = 2;
        int y2 = 3;
        float[] points = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        if (!TextUtils.isEmpty((CharSequence)direction)) {
            direction = direction.replaceAll("\\s*", "").toLowerCase(Locale.ROOT);
        }
        switch (direction) {
            case "toright": {
                points[x2] = width;
                break;
            }
            case "toleft": {
                points[x1] = width;
                break;
            }
            case "tobottom": {
                points[y2] = height;
                break;
            }
            case "totop": {
                points[y1] = height;
                break;
            }
            case "tobottomright": {
                points[x2] = width;
                points[y2] = height;
                break;
            }
            case "totopleft": {
                points[x1] = width;
                points[y1] = height;
            }
        }
        return points;
    }

    public static boolean isNamedColor(String name) {
        return colorMap.containsKey(name);
    }

    static {
        colorMap.put("aliceblue", -984833);
        colorMap.put("antiquewhite", -332841);
        colorMap.put("aqua", -16711681);
        colorMap.put("aquamarine", -8388652);
        colorMap.put("azure", -983041);
        colorMap.put("beige", -657956);
        colorMap.put("bisque", -6972);
        colorMap.put("black", -16777216);
        colorMap.put("blanchedalmond", -5171);
        colorMap.put("blue", -16776961);
        colorMap.put("blueviolet", -7722014);
        colorMap.put("brown", -5952982);
        colorMap.put("burlywood", -2180985);
        colorMap.put("cadetblue", -10510688);
        colorMap.put("chartreuse", -8388864);
        colorMap.put("chocolate", -2987746);
        colorMap.put("coral", -32944);
        colorMap.put("cornflowerblue", -10185235);
        colorMap.put("cornsilk", -1828);
        colorMap.put("crimson", -2354116);
        colorMap.put("cyan", -16711681);
        colorMap.put("darkblue", -16777077);
        colorMap.put("darkcyan", -16741493);
        colorMap.put("darkgoldenrod", -4684277);
        colorMap.put("darkgray", -5658199);
        colorMap.put("darkgreen", -16751616);
        colorMap.put("darkkhaki", -4343957);
        colorMap.put("darkmagenta", -7667573);
        colorMap.put("darkolivegreen", -11179217);
        colorMap.put("darkorange", -29696);
        colorMap.put("darkorchid", -6737204);
        colorMap.put("darkred", -7667712);
        colorMap.put("darksalmon", -1468806);
        colorMap.put("darkseagreen", -7357297);
        colorMap.put("darkslateblue", -12042869);
        colorMap.put("darkslategray", -13676721);
        colorMap.put("darkslategrey", -13676721);
        colorMap.put("darkturquoise", -16724271);
        colorMap.put("darkviolet", -7077677);
        colorMap.put("deeppink", -60269);
        colorMap.put("deepskyblue", -16728065);
        colorMap.put("dimgray", -9868951);
        colorMap.put("dimgrey", -9868951);
        colorMap.put("dodgerblue", -14774017);
        colorMap.put("firebrick", -5103070);
        colorMap.put("floralwhite", -1296);
        colorMap.put("forestgreen", -14513374);
        colorMap.put("fuchsia", -65281);
        colorMap.put("gainsboro", -2302756);
        colorMap.put("ghostwhite", -460545);
        colorMap.put("gold", -10496);
        colorMap.put("goldenrod", -2448096);
        colorMap.put("gray", -8355712);
        colorMap.put("grey", -8355712);
        colorMap.put("green", -16744448);
        colorMap.put("greenyellow", -5374161);
        colorMap.put("honeydew", -983056);
        colorMap.put("hotpink", -38476);
        colorMap.put("indianred", -3318692);
        colorMap.put("indigo", -11861886);
        colorMap.put("ivory", -16);
        colorMap.put("khaki", -989556);
        colorMap.put("lavender", -1644806);
        colorMap.put("lavenderblush", -3851);
        colorMap.put("lawngreen", -8586240);
        colorMap.put("lemonchiffon", -1331);
        colorMap.put("lightblue", -5383962);
        colorMap.put("lightcoral", -1015680);
        colorMap.put("lightcyan", -2031617);
        colorMap.put("lightgoldenrodyellow", -329006);
        colorMap.put("lightgray", -2894893);
        colorMap.put("lightgrey", -2894893);
        colorMap.put("lightgreen", -7278960);
        colorMap.put("lightpink", -18751);
        colorMap.put("lightsalmon", -24454);
        colorMap.put("lightseagreen", -14634326);
        colorMap.put("lightskyblue", -7876870);
        colorMap.put("lightslategray", -8943463);
        colorMap.put("lightslategrey", -8943463);
        colorMap.put("lightsteelblue", -5192482);
        colorMap.put("lightyellow", -32);
        colorMap.put("lime", -16711936);
        colorMap.put("limegreen", -13447886);
        colorMap.put("linen", -331546);
        colorMap.put("magenta", -65281);
        colorMap.put("maroon", -8388608);
        colorMap.put("mediumaquamarine", -10039894);
        colorMap.put("mediumblue", -16777011);
        colorMap.put("mediumorchid", -4565549);
        colorMap.put("mediumpurple", -7114533);
        colorMap.put("mediumseagreen", -12799119);
        colorMap.put("mediumslateblue", -8689426);
        colorMap.put("mediumspringgreen", -16713062);
        colorMap.put("mediumturquoise", -12004916);
        colorMap.put("mediumvioletred", -3730043);
        colorMap.put("midnightblue", -15132304);
        colorMap.put("mintcream", -655366);
        colorMap.put("mistyrose", -6943);
        colorMap.put("moccasin", -6987);
        colorMap.put("navajowhite", -8531);
        colorMap.put("navy", -16777088);
        colorMap.put("oldlace", -133658);
        colorMap.put("olive", -8355840);
        colorMap.put("olivedrab", -9728477);
        colorMap.put("orange", -23296);
        colorMap.put("orangered", -47872);
        colorMap.put("orchid", -2461482);
        colorMap.put("palegoldenrod", -1120086);
        colorMap.put("palegreen", -6751336);
        colorMap.put("paleturquoise", -5247250);
        colorMap.put("palevioletred", -2396013);
        colorMap.put("papayawhip", -4139);
        colorMap.put("peachpuff", -9543);
        colorMap.put("peru", -3308225);
        colorMap.put("pink", -16181);
        colorMap.put("plum", -2252579);
        colorMap.put("powderblue", -5185306);
        colorMap.put("purple", -8388480);
        colorMap.put("rebeccapurple", -10079335);
        colorMap.put("red", -65536);
        colorMap.put("rosybrown", -4419697);
        colorMap.put("royalblue", -12490271);
        colorMap.put("saddlebrown", -7650029);
        colorMap.put("salmon", -360334);
        colorMap.put("sandybrown", -744352);
        colorMap.put("seagreen", -13726889);
        colorMap.put("seashell", -2578);
        colorMap.put("sienna", -6270419);
        colorMap.put("silver", -4144960);
        colorMap.put("skyblue", -7876885);
        colorMap.put("slateblue", -9807155);
        colorMap.put("slategray", -9404272);
        colorMap.put("slategrey", -9404272);
        colorMap.put("snow", -1286);
        colorMap.put("springgreen", -16711809);
        colorMap.put("steelblue", -12156236);
        colorMap.put("tan", -2968436);
        colorMap.put("teal", -16744320);
        colorMap.put("thistle", -2572328);
        colorMap.put("tomato", -40121);
        colorMap.put("turquoise", -12525360);
        colorMap.put("violet", -1146130);
        colorMap.put("wheat", -663885);
        colorMap.put("white", -1);
        colorMap.put("whitesmoke", -657931);
        colorMap.put("yellow", -256);
        colorMap.put("yellowgreen", -6632142);
        colorMap.put("transparent", 0);
    }

    static enum ColorConvertHandler {
        NAMED_COLOR_HANDLER{

            @Override
            @NonNull
            Pair<Boolean, Integer> handle(String rawColor) {
                if (colorMap.containsKey(rawColor)) {
                    return new Pair((Object)Boolean.TRUE, colorMap.get(rawColor));
                }
                return new Pair((Object)Boolean.FALSE, (Object)0);
            }
        }
        ,
        RGB_HANDLER{

            @Override
            @NonNull
            Pair<Boolean, Integer> handle(String rawColor) {
                if (rawColor.length() == 4) {
                    int r = Integer.parseInt(rawColor.substring(1, 2), 16);
                    int g = Integer.parseInt(rawColor.substring(2, 3), 16);
                    int b = Integer.parseInt(rawColor.substring(3, 4), 16);
                    return new Pair((Object)Boolean.TRUE, (Object)Color.rgb((int)(r + (r << 4)), (int)(g + (g << 4)), (int)(b + (b << 4))));
                }
                if (rawColor.length() == 7 || rawColor.length() == 9) {
                    return new Pair((Object)Boolean.TRUE, (Object)Color.parseColor((String)rawColor));
                }
                return new Pair((Object)Boolean.FALSE, (Object)0);
            }
        }
        ,
        FUNCTIONAL_RGB_HANDLER{

            @Override
            @NonNull
            Pair<Boolean, Integer> handle(String rawColor) {
                SingleFunctionParser functionParser = new SingleFunctionParser(rawColor, FUNCTIONAL_RGB_MAPPER);
                List rgb = functionParser.parse(WXResourceUtils.RGB);
                if (null != rgb && rgb.size() == 3) {
                    return new Pair((Object)Boolean.TRUE, (Object)Color.rgb((int)((Integer)rgb.get(0)), (int)((Integer)rgb.get(1)), (int)((Integer)rgb.get(2))));
                }
                return new Pair((Object)Boolean.FALSE, (Object)0);
            }
        }
        ,
        FUNCTIONAL_RGBA_HANDLER{

            @Override
            @NonNull
            Pair<Boolean, Integer> handle(String rawColor) {
                SingleFunctionParser functionParser = new SingleFunctionParser(rawColor, FUNCTIONAL_RGBA_MAPPER);
                List rgba = functionParser.parse(WXResourceUtils.RGBA);
                if (rgba.size() == 4) {
                    return new Pair((Object)Boolean.TRUE, (Object)Color.argb((int)ColorConvertHandler.parseAlpha(((Number)rgba.get(3)).floatValue()), (int)((Number)rgba.get(0)).intValue(), (int)((Number)rgba.get(1)).intValue(), (int)((Number)rgba.get(2)).intValue()));
                }
                return new Pair((Object)Boolean.FALSE, (Object)0);
            }
        };


        @NonNull
        abstract Pair<Boolean, Integer> handle(String var1);

        private static int parseAlpha(float alpha) {
            return (int)(alpha * 255.0f);
        }
    }
}

